! -----------------------------------------------------------------------
!
! MODULE MAP_Util_Global_Data
!
! -----------------------------------------------------------------------
MODULE MAP_Util_Global_Data

SAVE

! -----------------------------------------------------------------------
!
! Set KIND Type
!
! -----------------------------------------------------------------------

  INTEGER,PARAMETER :: real_8_30 = SELECTED_REAL_KIND(P=8,R=30)

! -----------------------------------------------------------------------
! Physical constants used in calculations.
! Reference : "Fundamental physical constants and energy 
!              conversion factors",
! National Physical Laboratory.
!
!
!  HH is the Planck constant (in joules per hertz, J/Hz)
!  R is the molar gas constant (in joules per mole per kelvin, J/(mol K))
!  BOLTZ is the Boltzmann constant (in joules per kelvin, J/K)
!  T0 is the triple point of water (in kelvin)
!  AV is the Avogadro constant (in 1/(mole)
! -----------------------------------------------------------------------

      REAL(KIND=real_8_30),PARAMETER :: &
           HH   =6.6260755E-34, R =8.31451E+00, &
           BOLTZ=1.380658E-23, AV =6.0221367E+23, &
           T0   =273.15D+00

      REAL(KIND=real_8_30),PARAMETER :: PI=3.141592654D+00
CONTAINS
! -----------------------------------------------------------------------
!
! Function H_T
!   Calculates H1 value based on T
!
! -----------------------------------------------------------------------
  FUNCTION H_T(T)
    IMPLICIT NONE
!
! Arguments
!
    REAL(KIND=real_8_30),INTENT(IN) :: T
	REAL(KIND=real_8_30)        :: H_T
  
        IF (T .LE. 1000.0) THEN
           H_T = 111918.0E+00
        ELSE	  
           H_T = 105525.0E+00
        END  IF

  END FUNCTION H_T
! -----------------------------------------------------------------------
!
! Function S_T
!   Calculates S1 value based on T
!
! -----------------------------------------------------------------------
  FUNCTION S_T(T)
    IMPLICIT NONE
!
! Arguments
!
    REAL(KIND=real_8_30),INTENT(IN) :: T
	REAL(KIND=real_8_30)        :: S_T
  
        IF (T .LE. 1000.0) THEN
           S_T = 51.44E+00
        ELSE	  
           S_T = 45.34521E+00
        END  IF

  END FUNCTION S_T
! -----------------------------------------------------------------------
!
! FUNCTION AJ(T,W)
!
! -----------------------------------------------------------------------
  FUNCTION AJ(T,W)
    IMPLICIT NONE
!
! Arguments
!
    REAL(KIND=real_8_30),INTENT(IN) :: T,W
    REAL(KIND=real_8_30) :: AJ

      AJ  = 1.0E+00-EXP(-W/(R*T))    

  END FUNCTION AJ
! -----------------------------------------------------------------------


END MODULE MAP_Util_Global_Data
! -----------------------------------------------------------------------
