C
C To calculate the carbon concentration (mole fraction) at the
C  T-zero phase boundary at a specified temperature.
C
C H K D H Bhadeshia, University of Cambridge
C
      SUBROUTINE MAP_STEEL_AXTO(H,S,H1,S1,XTO,T,W,W1,F,AJ,AJ1,STORE,
     &JN,J,R)
C
      IMPLICIT NONE
      DOUBLE PRECISION H,S,H1,S1,XTO,T,W,W1,F,AJ,AJ1,R,STORE
      DOUBLE PRECISION MAP_STEEL_FTO1, MAP_STEEL_G91,DA,DFTO,G9
      INTEGER J,JN
C
C XTO is the carbon concentration at the T-zero boundary
C T is the absolute temperature
C STORE is the stored energy in Joules per mole
C H, S, H1, S1, W, W1, F, AJ, AJ1 are thermodynamic quantities
C  defined in subroutines OMEGA, ENERGY and main program
C
C Initialize J
C
      J=0
C
C Calculate the driving force for the transformation of
C  austenite to ferrite without any change in chemical composition,
C  allowing for Zener ordering
C
 10     DFTO=MAP_STEEL_FTO1(H,S,XTO,T,W,W1,H1,S1,F,AJ,AJ1,R)+STORE
C
C Solve for XTO using Newton's iterative method
C
         J=J+1
         DA=DABS(DFTO)
         IF (DA .LE. 10.0D+00) GOTO 100
C
C Obtain differential of FTO1 with respect to XTO
C
       G9=MAP_STEEL_G91(XTO,T,W,W1,H1,S1,F,H,S,AJ,AJ1,R)
C
C Modify original guess of XTO, assuming that convergence occurs
C  within nine iterations
C
         IF (J .GE. JN) GOTO 100
         XTO=XTO-DFTO/G9
         IF (XTO .LE. 1.0D-12) GOTO 50
         GOTO 10
 50      XTO=0.0000D+00
C
 100        RETURN
            END
