Copyright S. Atamert and H. K. D. H. Bhadeshia
C University of Cambridge, 1990
C
C     Nickel base superalloys                                   
C     Phase chemistries, mechanical properties             
C     S(I)= wt. % of alloying elements
C     K(I)= atomic weights                   
C     A(I)= atomic %               
C     Y(I)= atomic % in gamma prime                             
C     V(I)= atomic % in gamma
C     X= Al by gamma prime surface equation             
C     B= gamma prime lattice parameter
C     C= gamma lattic parameter
C     M= % lattice misfit
C     F= volume fraction of gamma prime
C     T= expansion coefficient                    
C           Ni Cr Mo Al Ti Co W Ta
C  AVER= version number
C
C
      IMPLICIT REAL*8(A-H,K-Z), INTEGER(I,J)
      DOUBLE PRECISION A(8),V(8),Y(8),K(8),S(8),P(8),VAC(8),
     &AS(8)
               P(1)=0.66
               P(2)=4.66
               P(3)=4.66
               P(4)=7.66
               P(5)=6.66
               P(6)=1.71
               P(7)=4.66
               P(8)=4.66
               K(1)=58.71
               K(2)=51.996
               K(3)=95.94
               K(4)=26.9815
               K(5)=47.90
               K(6)=58.9332
               K(7)=183.85
               K(8)=180.947
                AVER=1.1
      CALL LOGO4(AVER)
23    CALL RCOMP4(S,ID,0)
             AS(1)=S(1)
             AS(2)=S(2)
             AS(3)=S(3)
             AS(4)=S(4)
             AS(5)=S(5)
             AS(6)=S(6)
             AS(7)=S(7)
             AS(8)=S(8)
201   CALL DDTA4(AS,S,ID)
      T=(14.378+(0.0123*S(6)+0.0284*S(2)
     &-0.1012*S(3)-0.0520*S(7)
     &-0.1280*S(5)-0.0214*S(4)-0.0165*S(8)))*1.0D-06
          DO 10 I=1,8
10        A(I)=S(I)/K(I)
      SUMI=A(1)+A(2)+A(3)+A(4)+A(5)+A(6)+A(7)+A(8)
          DO 15 I=1,8
          A(I)=A(I)/SUMI
15        A(I)=A(I)*100
      F=0.003
4     IN=1
5         Y(2)=A(2)/(F+(1.0-F)*7.3737)
          Y(3)=A(3)/(F+(1.0-F)*3.9932)
          Y(4)=A(4)/(F+(1.0-F)*0.2413)
          Y(5)=A(5)/(F+(1.0-F)*0.1955)
          Y(6)=A(6)/(F+(1.0-F)*2.652)
          Y(7)=A(7)/(F+(1.0-F)*1.7615)
          Y(8)=A(8)/(F+(1.0-F)*0.2049)
          Y(1)=100-(Y(2)+Y(3)+Y(4)+Y(5)+Y(6)+Y(7)+Y(8))
      X=24.0484-(0.5765*Y(2))-(1.1096*Y(3))-(0.9016*Y(5))-(0.0292*Y(6))
      X=X-(1.0567*Y(7))-(1.1123*Y(8))
      DAL=X-Y(4)
      IF (DABS(DAL) .LT. 0.001) GOTO 50
      IF (IN .EQ. 2) GOTO 48
      DALO=DAL
      FO=F
      F=F+0.0001
      IN=IN+1
      GOTO 5
48    F=F-0.0001*DAL/(DAL-DALO)
      GOTO 4
50    V(2)=Y(2)*7.3737
      V(3)=Y(3)*3.9932
      V(4)=Y(4)*0.2413
      V(5)=Y(5)*0.1955
      V(6)=Y(6)*2.702
      V(7)=Y(7)*0.552
      V(8)=Y(8)*0.261
      V(1)=100-(V(2)+V(3)+V(4)+V(5))
      B=(3.5208+(4.35E-3*Y(3)+1.20E-3*Y(2)+
     &1.85E-3*Y(4)+3.40E-3*Y(5)
     &+0.2E-3*Y(6)+4.12E-3*Y(7)+6.3E-3*Y(8)))*0.1
      C=(3.5240+(4.35E-3*V(3)+1.20E-3*V(2)+
     &1.85E-3*V(4)+3.40E-3*V(5)
     &+0.2E-3*V(6)+4.12E-3*V(7)+6.3E-3*V(8)))*0.1
      SSS=-12.36+2.60*Y(6)-1.42*Y(2)-1.35*Y(3)+2.75*Y(7)
      OVERS=-106.42+1.58*Y(6)+1.43*Y(2)+4.70*Y(3)+7.45*Y(7)
     &+5.79*Y(4)+6.76*Y(5)+11.27*Y(8)
      PS=OVERS-SSS
      OVERS=9.08*OVERS
      SSS=9.08*SSS
      PS=9.08*PS
      M=((B-C)/B)*100
      DO 300 I=1,8
      VAC(I)=V(I)/100*P(I)
      SUMVAC=VAC(1)+VAC(2)+VAC(3)+VAC(4)+VAC(5)+VAC(6)+
     +VAC(7)+VAC(8)
300   CONTINUE
      UTS20=461.9+12.91*S(2)+2.473*S(6)+15.85*S(3)+9.621*S(7)
     &+26.95*S(8)+34.44*S(4)+32.51*S(5)
      UTS650=148.2+11.39*S(2)+4.088*S(6)+14.82*S(3)+11.80*S(7)
     &+29.21*S(8)+82.19*S(4)+61.05*S(5)
      UTS760=96.52+12.16*S(2)+1.008*S(6)+20.40*S(3)+15.19*S(7)
     &+33.17*S(8)+88.68*S(4)+58.29*S(5)
      UTS871=56.53+5.184*S(2)+2.559*S(6)+23.87*S(3)+12.93*S(7)
     &+28.21*S(8)+84.14*S(4)+37.96*S(5)
      UTS982=37.23-3.992*S(2)-0.0091*S(6)-0.55*S(3)+6.53*S(7)
     &+20.05*S(8)+67.91*S(4)+42.92*S(5)
      LATMIS=1.216-0.00202*S(1)+3.697D-3*S(2)+1.09D-1*S(3)
     &+0.7708D-1*S(4)
     &-0.4055D-1*S(5)-6.479D-3*S(6)-3.787D-3*S(7)-3.563D-3*S(8)
C
C
C
      CALL STARS
      IF (SUMVAC .LE. 2.30) THEN
      WRITE (*,20) SUMVAC
      ELSE
      WRITE (*,21)SUMVAC
      ENDIF
      WRITE (*,99)
      WRITE (*,119) (S(I),I=1,8)
      WRITE (*,120) (A(I),I=1,8)
      WRITE(*,22)
      WRITE (*,121) (Y(I),I=1,8)
      WRITE (*,122) (V(I),I=1,8)
      CALL STARS
      PAUSE 'Press Return to continue'
      CALL STARS
      WRITE (*,123) F
      WRITE (*,124) B
      WRITE (*,125) C
      WRITE (*,126) M
      WRITE (*,127) T
      WRITE (*,128) OVERS
      WRITE(*,89)
      WRITE(*,899)UTS20,UTS650,UTS760,UTS871,UTS982
      CALL STARS
      PAUSE 'Press Return to continue'
C
20    FORMAT(5X,'Electron-Vacancy concentration ',7X,F6.2/
     &       5X,'(matrix stable to the formation of '/
     &       5X,'topologically close-packed phases)'//)
21    FORMAT(5X,'Electron-Vacancy concentration ',7X,F6.2/
     &       5X,'(matrix UNSTABLE to the formation of '/
     &       5X,'topologically close-packed phases)'//)
22    FORMAT(5X,' Atomic %      Ni     Cr     Mo     Al    Ti',
     &'    Co       W     Ta')
99    FORMAT(5X,'               Ni     Cr     Mo     Al    Ti',
     &'    Co       W     Ta')
119   FORMAT(5X,' weight % ',8(2X,F5.2))
120   FORMAT(5X,' atomic % ',8(2X,F5.2)///)
121   FORMAT(5X,' Gamma-P  ',8(2X,F5.2))
122   FORMAT(5X,' Gamma    ',8(2X,F5.2)///)
123   FORMAT(//5X,' Volume fraction of Gamma-P   ',F5.2)
124   FORMAT(5X,' Gamma-P lattice parameter, nm ',F6.4)
125   FORMAT(5X,' Gamma   lattice parameter, nm ',F6.4)
126   FORMAT(5X,' Lattice misfit                ',F6.4//)
128   FORMAT(5X,' Overall tensile strength, MPa ',6X,,F8.0/)
127   FORMAT(5X,' Thermal expansion coefficient 811 K ' ,D12.4)
89    FORMAT(// 
     &5X,' Tensile Strength (MPa) versus Temperature (C)'//
     &5X,' Temperature   20       650',
     &'      760      871      982  ')
899   FORMAT(5X,' Strength ',5(2X,F7.0))
C
C
      WRITE(*,24)
24    FORMAT(/////////////
     &30X,' 1 = Revise input data'/
     &30X,' 2 = Start afresh     '/
     &30X,' 0 = Stop             '//)
      CALL REEDI(IYES)
      IF(IYES .EQ. 1)GOTO 201
      IF(IYES .EQ. 2)GOTO 23
      IF(IYES .EQ. 0)GOTO 200       
200   STOP  
      END
C
C
      SUBROUTINE STARS
      WRITE (*,1)
1     FORMAT(/'***************************************',
     &'*************************************'/)
      END

C
C-----------------------------------------------------------------------
      SUBROUTINE LOGO4(AVER)
      DOUBLE PRECISION AVER
      WRITE(*,432)
432   FORMAT(//////////)
      WRITE(*,1)
1     FORMAT(
     &10X,' *************************************************',
     &'**********')
      WRITE(*,2)
2     FORMAT(10X,' **',55X,'**')
      WRITE(*,2)
      WRITE(*,6)AVER
6     FORMAT(10X,' **',
     &    10X,'    NICKEL BASE SUPERALLOYS (V ',F3.1,')'
     &,10X,'**')
      WRITE(*,2)
      WRITE(*,2)
300   WRITE(*,2)
      WRITE(*,8)
8     FORMAT(10X,' **',8X,'                  by                  ',
     &9X,'**')
      WRITE(*,2)
      WRITE(*,9)
9     FORMAT(10X,' **',10X,' S. Atamert  & H. K. D. H. Bhadeshia  ',
     &7X,'**')
      WRITE(*,2)
      WRITE(*,10)
10    FORMAT(10X,' **',8X,'        University of Cambridge       ',
     &9X,'**')
      WRITE(*,11)
11    FORMAT(10X,' **',8X,'                                      ',
     &9X,'**')
      WRITE(*,2)
      WRITE(*,2)
      WRITE(*,1)
      WRITE(*,433)
433   FORMAT(////)
      PAUSE 'Press RETURN to continue'
      WRITE(*,432)
      WRITE(*,432)
      RETURN
      END
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
      SUBROUTINE REEDI(I)
      INTEGER I
996   READ(*,*,ERR=999)I
          GOTO 998
999       WRITE(*,997)
997       FORMAT(19X,' Incorrect Input. Try again'/)
          GOTO 996
998   RETURN
      END
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
      SUBROUTINE REED(A)
      DOUBLE PRECISION A
996   READ(*,*,ERR=999)A
          GOTO 998
999       WRITE(*,997)
997       FORMAT(19X,' Incorrect Input. Try again'/)
          GOTO 996
998   RETURN
      END
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
      SUBROUTINE RCOMP4(C,J6,JYES)
      DOUBLE PRECISION C(8)
      INTEGER J6,JYES
      IF(JYES .EQ. 1)GOTO 1
      IF(JYES .EQ. 2)GOTO 2
      IF(JYES .EQ. 3)GOTO 3
      IF(JYES .EQ. 4)GOTO 4
      IF(JYES .EQ. 5)GOTO 5
      IF(JYES .EQ. 6)GOTO 6
      IF(JYES .EQ. 7)GOTO 7
      WRITE(*,715)
715   FORMAT(////19X,' Identification Number ?')
      CALL REEDI(J6)
1     WRITE(*,707)
707   FORMAT(19X,' Chromium wt.% ?')
      CALL REED(C(2))
      IF(C(2) .LT. 0.0 .OR. C(2) .GT. 3.0D+01)
     &CALL BOUND(C(2),0.0D+00,3.0D+01)
      IF(JYES .NE. 0) GOTO 8
2     WRITE(*,708)
      CALL REED(C(3))
      IF(C(3) .LT. 0.0D+00 .OR. C(3) .GT. 2.0D+01)
     &CALL BOUND(C(3),0.0D+00,2.0D+01)
708   FORMAT(19X,' Molybdenum wt.% ?')
      IF(JYES .NE. 0) GOTO 8
3     WRITE(*,709)
      CALL REED(C(8))
      IF(C(8) .LT. 0.0D+00 .OR. C(8) .GT. 1.5D+01)
     &CALL BOUND(C(3),0.0D+00,1.5D+01)
709   FORMAT(19X,' Tantalum wt.% ?')
      IF(JYES .NE. 0) GOTO 8
4     WRITE(*,710)
      CALL REED(C(4))
      IF(C(4) .LT. 0.0D+00 .OR. C(4) .GT. 9.5D+00)
     &CALL BOUND(C(4),0.0D+00,9.5D+00)
710   FORMAT(19X,' Aluminium wt.% ?')
711   FORMAT(19X,' Titanium wt.% ?')
      IF(JYES .NE. 0) GOTO 8
5     WRITE(*,711)
      CALL REED(C(5))
      IF(C(5) .LT. 0.0D+00 .OR. C(5) .GT. 6.5D+00)
     &CALL BOUND(C(5),0.0D+00,6.5D+00)
712   FORMAT(19X,' Cobalt wt.% ?')
      IF(JYES .NE. 0) GOTO 8
6     WRITE(*,712)
      CALL REED(C(6))
      IF(C(6) .LT. 0.0D+00 .OR. C(6) .GT. 2.5D+01)
     &CALL BOUND(C(6),0.0D+00,2.5D+01)
713   FORMAT(19X,' Tungsten wt.% ?')
      IF(JYES .NE. 0) GOTO 8
7     WRITE(*,713)
      CALL REED(C(7))
      IF(C(7) .LT. 0.0D+00 .OR. C(7) .GT. 2.5D+01)
     &CALL BOUND(C(7),0.0D+00,2.5D+00)
8     JYES=0
      C(1)=100.0-C(2)-C(3)-C(4)-C(5)-C(6)-C(7)-C(8)
      RETURN
      END
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
      SUBROUTINE BOUND(A,B,C)
      DOUBLE PRECISION A,B,C
2      WRITE(*,1)B,C
1     FORMAT(12X,' Input value out of bounds'/
     &14X,' The limits are ',D12.4,' to ', D12.4/)
      CALL REED(A)
      IF(A .LT. B .OR. A .GT. C)GOTO 2
      RETURN
      END
C*********************************************************************
C -------------------------------------------------------------
      SUBROUTINE DDTA4(AC,C,ID)
      IMPLICIT REAL*8(A-H,K-Z), INTEGER(I,J)
      DOUBLE PRECISION AC(8),C(8)
22    WRITE(*,23) AC(2),AC(3),AC(4),AC(5),
     & AC(6),AC(7),AC(8),ID
23    FORMAT(/////////' *********************************'
     &,'*********************************************'//
     &10X' Current values of some input parameters'//
     &10X,'  1. Cr ',F8.3/10X,'  2. Mo ',F8.3,10X,
     &'  3. Al ',F8.3/10X,'  4. Ti ',F8.3,10X,
     &'  5. Co ',F8.3/10X,'  6. W  ',F8.3,10X,
     &'  7. Ta ',F8.3///
     &10X,'  8. ID No.  ',I5  ,//
     &//10X,' ANY ALTERATIONS ?'//20X,
     & ' (Choose item number,   or Continue = 0) '//
     &' *********************************'
     &,'*********************************************'//)
      CALL REEDI(JYES)
      CALL BOUNDI(JYES,0,8)
      IF(JYES .EQ. 0) GOTO 24
      IF(JYES .EQ. 1) GOTO 1
      IF(JYES .EQ. 2) GOTO 1
      IF(JYES .EQ. 3) GOTO 1
      IF(JYES .EQ. 4) GOTO 1
      IF(JYES .EQ. 5) GOTO 1
      IF(JYES .EQ. 6) GOTO 1
      IF(JYES .EQ. 7) GOTO 1
      IF(JYES .EQ. 8) GOTO 12
1     CALL RCOMP4(AC,J6,JYES)
      GOTO 22
12    WRITE(*,*)'                    Identification number ?'
      CALL REEDI(J6)
      GOTO 22
24    DO 30 I = 1, 8
      C(I)=AC(I)
30    CONTINUE
      RETURN
      END
C -------------------------------------------------------------
      SUBROUTINE BOUNDI(I,IJ,IK)
4     IF(I .LT. IJ .OR. I .GT. IK)GOTO 2
      GOTO 3
2      WRITE(*,1)IJ,IK
1     FORMAT(12X,' Input value out of bounds'/
     &14X,' The limits are ',I4,' to ', I4/)
      CALL REEDI(I)
      GOTO 4
3     RETURN
      END
