c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 
c
c...This s/r anneals the lattice for one cycle(?)
c
      subroutine anneal(cycle,orient,size,iterations,nmov,dims,
     >                    movable, beta, cool, angmax, ierr)
c
      implicit none
c
c...passed variables
c
      integer             cycle
      integer             size(3)
      double precision    orient(3,size(1),size(2),size(3))
      integer             iterations,nmov,ntrial
      integer             dims
      logical             movable(size(1),size(2),size(3))
      integer             cool
      double precision    angmax
      integer             ierr
c
c...local variables
c
      double precision    num 
      double precision    rand         !external 
      integer             i, j, k
      integer             iup, jup, kup
      integer             ilow, jlow, klow
      double precision    splay, twist, bend, saddlesplay, field
      integer             loop, loop2
      double precision    current(3)
      double precision    total_new, total_cur
      double precision    factor, delta_e
      double precision    ratio, beta
      double precision    acceptance_ratio
      integer             accept, ncount
      logical             more
      real                REQUIRED_RATIO
      parameter           (REQUIRED_RATIO = 0.5)
c
#include "params.inc"
#include "elastic_constants.inc"
c
c...executable code
c
      ierr = 0
c
      ntrial = 500
      ncount = 0
      accept = 0
      do loop = 1 , iterations*nmov
        ncount = ncount + 1
        more = .true.
c
c...keep trying until we get a cell which can move
c
        do while (more)
c
c...get random numbers for the position of a new trial cell
c
          num = rand()
          k = int ( 1.0d0 + size(3) * num )
          num = rand()
          j = int ( 1.0d0 + size(2) * num ) 
          num = rand()
          i = int ( 1.0d0 + size(1) * num )
c
c...if the cell may move then continue
c
          if (movable(i,j,k)) then
c
c...work out the positions of the six neighbours 
c   (if they are at the edges then they must form periodic
c   boundaries.)
c
c
            kup = mod(size(3)+k,size(3)) + 1
            klow = mod(size(3)+k-2,size(3)) + 1
            jup = mod(size(2)+j,size(2)) + 1
            jlow = mod(size(2)+j-2,size(2)) + 1
            iup = mod(size(1)+i,size(1)) + 1
            ilow = mod(size(1)+i-2,size(1)) + 1
c
c...we have found a movable vector
c
            more = .false.
          endif
        enddo
c
c...get the energy of this cell at the moment
c
        call group_energy(size, 
     >            orient(1,1,1,1), i, j, k, 
     >            ilow, iup, jlow, jup, klow, kup, 
     >            splay, twist, bend, saddlesplay, field, ierr) 
c
        total_cur = splay + twist + bend + saddlesplay + field
c
c...store current vector
c
        current(1) = orient(1,i,j,k)
        current(2) = orient(2,i,j,k)
        current(3) = orient(3,i,j,k)
c
c...calculate new trial orientation
c
        call isotropic(angmax,orient(1,i,j,k),orient(1,i,j,k),dims,ierr)
c
c...get the energy of this cell in its new, trial orientation
c
        call group_energy(size, 
     >            orient(1,1,1,1), i, j, k, 
     >            ilow, iup, jlow, jup, klow, kup, 
     >            splay, twist, bend, saddlesplay, field, ierr)
c 
        total_new = splay + twist + bend + saddlesplay  + field
        delta_e = total_new - total_cur
c
c...Metropolis test 
c
        factor = min(1,exp(-beta*delta_e))
        if (rand() .lt. factor) then
c
c...accept new orient
c
          accept = accept + 1
        else
c
c...copy back previous
c
          orient(1,i,j,k) = current(1)
          orient(2,i,j,k) = current(2)
          orient(3,i,j,k) = current(3)
        endif
c
c...Check whether to adjust angmax 
c   Don't do this on the first anneal cycle 
c
        if (ncount .eq. ntrial .and. cool .gt. 1) then
          acceptance_ratio = real(accept)/real(ntrial)
c
c...prevent changes in angle of more than an order of magnitude
c
          ratio = min(max((acceptance_ratio/REQUIRED_RATIO),0.1),10.0)
          angmax = ratio * angmax
c
c...never accept angles greater than 90 degrees
c
c          write(*,'(2f12.6)')acceptance_ratio, angmax
          if (angmax .gt. 90.0) angmax = 90.0d0
          ncount = 0
          accept = 0
        endif
c
      enddo
c
      return
c
      end
