c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

      subroutine energy(n,
     >              nxm, nxp,
     >              nym, nyp,
     >              nzm, nzp,
     >              xm, xp, ym, yp, zm, zp,
     >              splay, twist, bend, k_24, ierr)
c
      implicit none
c
      double precision      n(3)
      double precision      nxm(3), nxp(3)
      double precision      nym(3), nyp(3)
      double precision      nzm(3), nzp(3)
      integer               xm, xp, ym, yp, zm, zp
      double precision      splay, twist, bend, k_24
      double precision      nx(3,2), ny(3,2), nz(3,2)
      integer               ierr
      integer               i, j, k
      double precision      s, phi, theta
      integer               dotx, doty, dotz
      integer               x, y, z, p
      double precision      b1, b2, b3
      double precision      e1, e2, e3
      double precision      t, e, factor
      double precision      dnxdx, dnydx, dnzdx
      double precision      dnxdy, dnydy, dnzdy
      double precision      dnxdz, dnydz, dnzdz
      integer               isign, jsign, ksign
c
#include "elastic_constants.inc"
c
c...copy in vectors
c
      do i = 1, 3
        nx(i,1) = nxm(i)
        nx(i,2) = nxp(i)
        ny(i,1) = nym(i)
        ny(i,2) = nyp(i)
        nz(i,1) = nzm(i)
        nz(i,2) = nzp(i)
      enddo
c
c...initialise values
c
      splay = 0.0d0
      twist = 0.0d0
      bend  = 0.0d0
      k_24  = 0.0d0
c
      do k =  zm, zp
        ksign = -1
        if (k.eq.2) ksign = 1
c
c...dot products for neighbour along z
c
        dotz = sign(1.0d0 , nz(1,k)*n(1) +
     >                      nz(2,k)*n(2) +
     >                      nz(3,k)*n(3))
c
c...Calulate derivatives wrt z
c
        dnxdz = ksign*(dotz*nz(1,k) - n(1))
        dnydz = ksign*(dotz*nz(2,k) - n(2))
        dnzdz = ksign*(dotz*nz(3,k) - n(3))
c
        do j =  ym, yp
          jsign = -1
          if (j.eq.2) jsign = 1
c
c...dot products for neighbour along y
c
          doty = sign(1.0d0 , ny(1,j)*n(1) +
     >                        ny(2,j)*n(2) +
     >                        ny(3,j)*n(3))
c
c...Calulate derivatives wrt y
c
          dnxdy = jsign*(doty*ny(1,j) - n(1))
          dnydy = jsign*(doty*ny(2,j) - n(2))
          dnzdy = jsign*(doty*ny(3,j) - n(3))
c
          do i =  xm, xp
            isign = -1
            if (i.eq.2) isign = 1
c
c...dot products for neighbour along x
c
            dotx = sign(1.0d0 , nx(1,i)*n(1) +
     >                          nx(2,i)*n(2) +
     >                          nx(3,i)*n(3))
c
c...Calulate derivatives wrt x
c
            dnxdx = isign*(dotx*nx(1,i) - n(1))
            dnydx = isign*(dotx*nx(2,i) - n(2))
            dnzdx = isign*(dotx*nx(3,i) - n(3))
c...Splay energy
c
            s = dnxdx + dnydy + dnzdz
            splay = splay + s * s
c
c...Twist Energy
c
            t = n(1) * (dnzdy - dnydz) +
     >          n(2) * (dnxdz - dnzdx) +
     >          n(3) * (dnydx - dnxdy)
            twist = twist + (t+0.1564d0) * (t+0.1564d0)
c
c...Bend energy
c
            b1 = n(2) * (dnydx - dnxdy) +
     >           n(3) * (dnzdx - dnxdz)
            b2 = n(3) * (dnzdy - dnydz) +
     >           n(1) * (dnxdy - dnydx)
            b3 = n(1) * (dnxdz - dnzdx) + 
     >           n(2) * (dnydz - dnzdy)
            bend = bend + b1*b1 + b2*b2 + b3*b3
c
c...k24 energy
c
            e =    dnxdx * dnydy 
     >          +  dnydy * dnzdz 
     >          +  dnzdz * dnxdx 
     >          -  dnxdy * dnydx
     >          -  dnydz * dnzdy
     >          -  dnzdx * dnxdz 
            k_24 = k_24 - 2 * e
          enddo
        enddo
      enddo
c
c...work out values with constants etc
c   division by 2 for Frank energy equation
c   division by 8 since 8 corners 
c         
      splay = k1 * splay / 16.0d0
      twist = k2 * twist / 16.0d0
      bend  = k3 * bend  / 16.0d0
      k_24  = k24 * k_24 / 16.0d0

      return

      end
