c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

c                       
      subroutine input(filename,size,dimensions,cycles,iterations,
     >                       nanneal, geometry,ierr )
c                       
      implicit none
c
c...passed variables
c
      integer            size(3)
      integer            cycles
      integer            iterations
      integer            nanneal
      integer            dimensions
      character*(*)      geometry
      integer            ierr
      character*80       filename
c
c...local variables
c
      character*80       line 
      integer            length    !external
      logical            more
      integer            iseed
c
#include "params.inc"
#include "elastic_constants.inc"
#include "files.inc"
c
      open(unit = IIN, file = filename, status = 'old', err = 400)
c
c...default values if not found in file
c
      size(1) = 10
      size(2) = 10
      size(3) = 10
      k1 = 1.0d0
      k2 = 1.0d0
      k3 = 1.0d0
      k24 = 0.0d0
      kf = 0.0d0
      cycles = 10
      dimensions = 3
      iterations = 100
      betainit = 5.0d13
      betafactor = 1.0d0
      nanneal = 1
      delta = 0.0d0
c
c...read from file
c
      more = .true.
      do while (more)
        read(IIN,'(1a)',end=300,err=500)line
c
c...keyword XSIZE
c
        if (line(1:5).eq.'XSIZE') then
          read(line(6:80),'(1i)')size(1)
c
c...keyword YSIZE
c
        elseif (line(1:5).eq.'YSIZE') then
          read(line(6:80),'(1i)')size(2)
c
c...keyword ZSIZE
c
        elseif (line(1:5).eq.'ZSIZE') then
          read(line(6:80),'(1i)')size(3)
c
c...GEOMETRY
c
        elseif (line(1:8).eq.'GEOMETRY') then
          geometry = line(10:length(line))
c
c...keyword DIMENSIONS
c
        elseif (line(1:10).eq.'DIMENSIONS') then
          read(line(11:80),'(1i)')dimensions
c
c...keyword SPLAY
c
        elseif (line(1:5).eq.'SPLAY') then
          read(line(6:80),*)k1
c
c...keyword TWIST
c
        elseif (line(1:5).eq.'TWIST') then
          read(line(6:80),*)k2
c
c...keyword BEND
c
        elseif (line(1:4).eq.'BEND') then
          read(line(5:80),*)k3
c
c...keyword K24
c
        elseif (line(1:3).eq.'K24') then
          read(line(5:80),*)k24
c
c...keyword FIELD
c
        elseif (line(1:5).eq.'FIELD') then
          read(line(7:80),*)kf
c
c...keyword DELTA
c
        elseif (line(1:5).eq.'DELTA') then
          read(line(7:80),*)delta
c
c...keyword CYCLES
c
        elseif (line(1:6).eq.'CYCLES') then
          read(line(7:80),*)cycles
c
c...keyword ITERATIONS
c
        elseif (line(1:10).eq.'ITERATIONS') then
          read(line(11:80),*)iterations
c
c...keyword DIRECTORY
c
        elseif (line(1:9).eq.'DIRECTORY') then
          DIRECTORY = line(11:length(line))
c
c...keyword GEOMFILE
c
        elseif (line(1:8).eq.'GEOMFILE') then
          GEOMFILE = line(10:length(line))
c
c...keyword MOVEFILE
c
        elseif (line(1:8).eq.'MOVEFILE') then
          MOVEFILE = line(10:length(line))
c
c...keyword SEED
c
        elseif (line(1:4).eq.'SEED') then
          read(line(5:80),*)iseed
          call srand(iseed)
c
c...keyword BETAINIT
c
        elseif (line(1:8).eq.'BETAINIT') then
          read(line(9:80),*)betainit
c
c...keyword BETAFACTOR
c
        elseif (line(1:10).eq.'BETAFACTOR') then
          read(line(11:80),*)betafactor
c
c...keyword NANNEAL
c
        elseif (line(1:7).eq.'NANNEAL') then
          read(line(8:80),'(1i)')nanneal
c
c...keyword ANGLEFACTOR
c
        elseif (line(1:11).eq.'ANGLEFACTOR') then
          read(line(13:80),*)anglefactor
        endif
      enddo
c
300   continue
c
      close(IIN)

      if (size(1) .lt. 3 .or.
     >    size(2) .lt. 3 .or.
     >    size(3) .lt. 3) then
        write(*,*)'Must have sizes greater than 3'
        stop
      endif

      return            
c                       
400   stop "ERROR opening input file"
500   stop "ERROR in file input"
      end               
