c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

c
c...this s/r returns a vector which is randomly oriented in space
c
      subroutine isotropic(angle,vin,v,dims,ierr)
c
      implicit none
c
c...passed variables
c
      double precision    angle
      double precision    vin(3)
      double precision    v(3)
      integer             dims
      integer             ierr
c
c...local variables
c
      double precision    rand                  !external
      double precision    s
      double precision    a
      double precision    phi
      double precision    cangle, rt
      double precision    theta_old, phi_old
      double precision    x, y, z
c
#include "pi.inc"
c
      if (dims .eq. 3 .and. angle.ge. 90.0d0) then

        phi   = rand() * 2.0d0 * PI
        a = 1.0d0 - 2.0d0 * rand()    !theta = acos(a)
c
        s = sqrt ( 1.0d0 - a * a )
        v(1) = s*cos(phi) 
        v(2) = s*sin(phi) 
        v(3) = a                      !v(3) = cos(acos(a)) = a!!

      elseif (dims.eq.3 .and. angle .lt. 90.0d0) then

        phi   = rand() * 2.0d0 * PI
        cangle = cos(angle*PI/180.0d0)
        a = cangle + (1-cangle)*rand() !theta = acos(a)
c
        s = sqrt ( 1.0d0 - a * a )
        x = s*cos(phi) 
        y = s*sin(phi) 
        z = a                      !v(3) = cos(acos(a)) = a!!
        rt = vin(1)*vin(1)+vin(2)*vin(2)
        if (rt .gt. 0.0d0) then
          phi_old = acos(vin(1)/sqrt(rt))
        else
          phi_old = 0.0d0
        endif
        if (vin(2).lt.0.0d0)phi_old = 2*PI - phi_old
        theta_old = acos(vin(3))
c
        v(1) = x * cos(phi_old) * cos(theta_old)
     >       - y * sin(phi_old)
     >       + z * cos(phi_old)*sin(theta_old) 
        v(2) = + x * sin(phi_old)*cos(theta_old) 
     >       + y * cos(phi_old)
     >       + z * sin(theta_old)*sin(phi_old) 
        v(3) = - x * sin(theta_old) 
     >         + z * cos(theta_old)
      elseif (dims .eq. 2) then
c
        phi   = rand() * 2.0d0 * PI
c
        v(1) = cos(phi) 
        v(2) = sin(phi) 
        v(3) = 0.0d0
c
      else 
        write(*,*)'Unrecognised dimension in isotropic'
        ierr = 1
      endif
c
      return
c
      end
