c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

c
c...This is the main program for a new lattice model.
c   It is being written under the SCCS system so that 
c   all work from now on can be documented and results
c   can be recreated from a given date and time without
c   the need to keep versions of the program.
c
      subroutine lattice(orient,size,movable,dims,
     >                             cycles,iterations,
     >                             nanneal, geometry,ierr)
c
      implicit none
c
c...passed variables
c 
      integer             size(3)
      double precision    orient(3,size(1),size(2),size(3))
      logical             movable(size(1),size(2),size(3))
      integer             cycles, iterations, dims, nanneal
      character*(*)       geometry
      integer             ierr
c
c...local variables
c
      double precision    beta, angmax
      integer             nmov, iter_per_cycle, cool
      integer             iter
#include "params.inc"
#include "elastic_constants.inc"
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c...SETUP
c
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      call setup(orient,size,movable,nmov,dims,geometry,ierr)
      if (ierr .ne. 0) then
        write(*,*)'ERROR - returned from setup'
      endif
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c...OUTPUT START LATTICE
c
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      call output(0,orient,size,movable,dims,ierr)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c...ANNEALING
c
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      iter_per_cycle = nmov * iterations
      do iter = 1 , cycles
c
c...if we are annealing each cycle then set up each time
c
        if (nanneal.gt.1) then 
          call setup(orient,size,movable,nmov,dims,geometry,ierr)
        endif
c
        beta = betainit
        angmax = 90.0d0
c
        do cool = 1, nanneal
c
          call anneal(iter,orient,size,iterations,nmov,
     >               dims,movable,beta,cool,angmax,ierr)
          if (ierr .ne. 0) then
            write(*,*)'ERROR - returned from anneal'
          endif
c
          beta = beta * betafactor
c
        enddo
c
        call output(iter,orient,size,movable,dims,ierr)
c
        kf = kf + delta
      enddo
c
      write(*,'(1a,1i,1a)')'Finished ',iterations*cycles,' Iterations'
      write(*,'(1a,1i,1a)')'Finished ',iter_per_cycle*cycles,' MCS'
c
      return
c
      end
