c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

c
c...This program supplies the memory allocation
c
      program main 
c
      implicit none
c
c...work in double precision
c
      double precision  array(1)
      pointer           (iptr, array)
      integer           nbytes
c
      logical           marray(1)
      pointer           (mptr, marray)
c
      integer           size(3)
      integer           cycles
      integer           iterations
      integer           nanneal
      integer           dims
      character*80      geometry
      integer           ierr
      character*80      outfile
      character*80      inputfile
      integer           length
c
#include "params.inc"
#include "elastic_constants.inc"
#include "files.inc"
c
c...start of executable code
c
      ierr = 0
c
c...get the input file from the command line
c
      call getarg(1,inputfile)
c
c...read the input file
c
      call input(inputfile,
     >          size,dims,cycles,iterations,nanneal,geometry,ierr)
c
c...write general information to the output file
c
      outfile = DIRECTORY(1:length(DIRECTORY))//'/OUT'
      open (unit=SO,file=outfile,status='unknown')
      write(SO,'(1a,3i4)')   'Size of Lattice   : ',size
      write(SO,'(1a,1pe9.2)')'Splay             : ',k1
      write(SO,'(1a,1pe9.2)')'Twist             : ',k2
      write(SO,'(1a,1pe9.2)')'Bend              : ',k3
      write(SO,'(1a,1pe9.2)')'Sin Squared       : ',k24
      write(SO,'(1a,1pe9.2)')'Field             : ',kf
      write(SO,'(1a,1i)')    'Cycles            : ',cycles
      write(SO,'(1a,1i)')    'Iterations        : ',iterations
      write(SO,'(1a,1i)')    'Nanneal           : ',nanneal
      write(SO,'(1a,1pe9.2)')'Betainit          : ',betainit
      write(SO,'(1a,1pe9.2)')'Betafactor        : ',betafactor
      write(SO,'(1a,1pe9.2)')'Anglefactor       : ',anglefactor
      write(SO,'(1a,1i)')    'Dimensions        : ',dims
      call flush(SO)
c
c...number of bytes for vector array is size cubed times 3 
c   since we have a vector at
c   each site and times 8 since we have double precision.
c
      nbytes = size(1) * size(2) * size(3) * 3 * 8
      iptr = malloc(nbytes)
c
c...number of bytes for movable array is size cubed * 4.
c   It would be nice to use logical*1 to save space but this
c   doesn't seem to work.
c
      nbytes = size(1) * size(2) * size(3) * 4
      mptr = malloc(nbytes)
c
c...call the actual program that does the work
c
      call lattice(array,size,marray,dims,cycles,iterations,
     >                    nanneal,geometry,ierr)
      if (ierr .ne. 0) then
        write(*,*)'ERROR - returned from lattice'
      endif
c
      call free(iptr)
      call free(mptr)
      call close(SO)
c
      end
