c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

      subroutine one_energy(n, 
     >              nxm, nxp,
     >              nym, nyp,
     >              nzm, nzp,
     >              splay, twist, bend, k_24, ierr)
c
      implicit none
c
      double precision      n(3)
      double precision      nxm(3), nxp(3)
      double precision      nym(3), nyp(3)
      double precision      nzm(3), nzp(3)
      double precision      splay, twist, bend, k_24
c
      integer               ierr
      integer               i, j, k
      double precision      s, phi, theta
      integer               dotx, doty, dotz
      integer               x, y, z, p
      double precision      b1, b2, b3
      double precision      e1, e2, e3
      double precision      t, e, factor
      double precision      dnxdx, dnydx, dnzdx
      double precision      dnxdy, dnydy, dnzdy
      double precision      dnxdz, dnydz, dnzdz
      integer               isign, jsign, ksign
c
#include "elastic_constants.inc"
c
c...initialise values
c
      splay = 0.0d0
      twist = 0.0d0
      bend = 0.0d0
      k_24 = 0.0d0
c
c...dot products for neighbour along z
c
      dotz = sign(1.0d0 , nzm(1)*nzp(1) +
     >                    nzm(2)*nzp(2) +
     >                    nzm(3)*nzp(3))
c
c...Calulate derivatives wrt z
c
      dnxdz = (dotz*nzp(1) - nzm(1))
      dnydz = (dotz*nzp(2) - nzm(2))
      dnzdz = (dotz*nzp(3) - nzm(3))
c
c
c...dot products for neighbour along y
c
      doty = sign(1.0d0 , nym(1)*nyp(1) +
     >                    nym(2)*nyp(2) +
     >                    nym(3)*nyp(3))
c
c...Calulate derivatives wrt y
c
      dnxdy = (doty*nyp(1) - nym(1))
      dnydy = (doty*nyp(2) - nym(2))
      dnzdy = (doty*nyp(3) - nym(3))
c
c...dot products for neighbour along x
c
      dotx = sign(1.0d0 , nxm(1)*nxp(1) +
     >                    nxm(2)*nxp(2) +
     >                    nxm(3)*nxp(3))
c
c...Calulate derivatives wrt x
c
      dnxdx = (dotx*nxp(1) - nxm(1))
      dnydx = (dotx*nxp(2) - nxm(2))
      dnzdx = (dotx*nxp(3) - nxm(3))
c
c...Splay energy
c
      s = dnxdx + dnydy + dnzdz
      splay = s * s
c
c...Twist Energy
c
      t = n(1) * (dnzdy - dnydz) +
     >    n(2) * (dnxdz - dnzdx) +
     >    n(3) * (dnydx - dnxdy)
      twist = t * t
c
c...Bend energy
c
      b1 = n(2) * (dnydx - dnxdy) +
     >     n(3) * (dnzdx - dnxdz)
      b2 = n(3) * (dnzdy - dnydz) +
     >     n(1) * (dnxdy - dnydx)
      b3 = n(1) * (dnxdz - dnzdx) + 
     >     n(2) * (dnydz - dnzdy)
      bend = bend + b1*b1 + b2*b2 + b3*b3
c
c...k24 energy
c
      e =    dnxdx * dnydy 
     >    +  dnydy * dnzdz 
     >    +  dnzdz * dnxdx 
     >    -  dnxdy * dnydx
     >    -  dnydz * dnzdy
     >    -  dnzdx * dnxdz 
      k_24 = k_24 - 2 * e
c
      splay = k1 * splay / 16.0d0
      twist = k2 * twist / 16.0d0
      bend  = k3 * bend  / 16.0d0
      k_24  = k24 * k_24 / 16.0d0

      return

      end
