c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

c                       
      subroutine output(id,ar,size,movable,dims,ierr)
c
      implicit none
c
c...passed variables
c
      integer  id
      integer  size(3)
      double precision ar(3,size(1),size(2),size(3))
      logical          movable(size(1),size(2),size(3))
      integer          dims
      integer ierr
      integer length
c                       
c...local variables
c
      character*100     filenamev, filenamee, filename
      integer           i,j,k, m
      double precision  splay, twist, bend, k_24, field
      double precision  sp, tw, be, k24
      double precision  tsplay, ttwist, tbend, tk_24, tfield
      double precision  total, x, y, radiussqr,factor
      integer           ilow,iup,jlow,jup,klow,kup
      integer           ilowuse, iupuse, istep, ii
      integer           jlowuse, jupuse, jstep, jj
      integer           klowuse, kupuse, kstep, kk
c
#include "params.inc"
#include "files.inc"
c
c...executable code
c
      ierr = 0
c
      if (id.ge.0 .and. id.le.9) then
        write(filenamev,'(2a,1i1,1a)')
     >              DIRECTORY(1:length(DIRECTORY)),'/vector0',id,'.dat'
        write(filenamee,'(2a,1i1,1a)')
     >              DIRECTORY(1:length(DIRECTORY)),'/energy0',id,'.dat'
      elseif (id.ge.10 .and. id.le.99) then
        write(filenamev,'(2a,1i2,1a)')
     >              DIRECTORY(1:length(DIRECTORY)),'/vector',id,'.dat'
        write(filenamee,'(2a,1i2,1a)')
     >              DIRECTORY(1:length(DIRECTORY)),'/energy',id,'.dat'
      else
        goto 400
      endif
c
      open(unit = IOUT, file = filenamev, status = 'unknown', err = 500)
      open(unit = EOUT, file = filenamee, status = 'unknown', err = 500)
c
c...we use a reversed format here for compatibility with Marc's
c   plot program. Writes out over k then j then i.
c
      total = 0.0d0
      tsplay= 0.0d0
      tbend = 0.0d0
      ttwist= 0.0d0
      tk_24= 0.0d0
      tfield= 0.0d0
      do i = 1 , size(1)
        do j = 1 , size(2)
          do k = 1 , size(3)
c
c...write out vector data
c
              write(IOUT,'(3f9.5)')(ar(m,i,j,k),m=1,3)
c
c...work out energies and write them out
c
              kup = mod(size(3)+k,size(3)) + 1
              klow = mod(size(3)+k-2,size(3)) + 1
              jup = mod(size(2)+j,size(2)) + 1
              jlow = mod(size(2)+j-2,size(2)) + 1
              iup = mod(size(1)+i,size(1)) + 1
              ilow = mod(size(1)+i-2,size(1)) + 1
c
              if (movable(i,j,k)) then
                factor = 1.0d0
                call energy(ar(1,i,j,k),
     >                      ar(1,ilow,j,k),ar(1,iup,j,k),
     >                      ar(1,i,jlow,k),ar(1,i,jup,k),
     >                      ar(1,i,j,klow),ar(1,i,j,kup),
     >                      1, 2, 1, 2, 1, 2,
     >                      splay, twist, bend, k_24, ierr)
              else
c
c...working out energies for fixed cells is more tricky.
c   there are eight cases - could write them in explicitly.
c
                factor = 0.0d0
                splay =  0.0d0
                twist =  0.0d0
                bend  =  0.0d0
                k_24  =  0.0d0
                do ilow = i-1, i
                  iup = ilow + 1
                  ilowuse = mod(size(1)+ilow-1, size(1)) + 1
                  iupuse = mod(size(1)+iup-1, size(1)) + 1
                  istep = iupuse - ilowuse
                  if (istep .le. 0)istep = 1
                  do jlow = j-1, j
                    jup = jlow + 1
                    jlowuse = mod(size(2)+jlow-1, size(2)) + 1
                    jupuse = mod(size(2)+jup-1, size(2)) + 1
                    jstep = jupuse - jlowuse
                    if (jstep .le. 0)jstep = 1
                    do klow = k-1, k
                      kup = klow + 1
                      klowuse = mod(size(3)+klow-1, size(3)) + 1
                      kupuse = mod(size(3)+kup-1, size(3)) + 1
                      kstep = kupuse - klowuse
                      if (kstep .le. 0)kstep = 1
                      do ii = ilowuse, iupuse, istep 
                        do jj = jlowuse, jupuse, jstep 
                          do kk = klowuse, kupuse, kstep 
                            if (movable(ii,jj,kk)) then
                              call one_energy(ar(1,i,j,k),
     >                          ar(1,ilowuse,j,k),ar(1,iupuse,j,k),
     >                          ar(1,i,jlowuse,k),ar(1,i,jupuse,k),
     >                          ar(1,i,j,klowuse),ar(1,i,j,kupuse),
     >                          sp, tw, be, k24, ierr)
                              splay =  splay + sp
                              twist =  twist + tw
                              bend  =  bend + be
                              k_24  =  k_24 + k24
                              factor = factor + 0.125d0
                              goto 50
                            endif
                          enddo
                        enddo
                      enddo
50                    continue
                    enddo
                  enddo
                enddo
                
              endif
              call field_energy(ar(1,i,j,k), field, ierr)
              field = field * factor
c              write(EOUT,'(5(1pe12.3))')splay,twist,bend,k_24,
c     >                             splay+twist+bend+k_24+field
              write(EOUT,'(1pe12.3)')splay+twist+bend+k_24+field
              tsplay = tsplay + splay
              ttwist = ttwist + twist
              tbend  = tbend  + bend
              tk_24 = tk_24 + k_24
              tfield = tfield + field
          enddo
        enddo
      enddo
c
      write(SO,'(1a,1i4)')    'Cycle      : ',id
      write(SO,'(1a,1pe20.6)')'Splay      : ',tsplay
      write(SO,'(1a,1pe20.6)')'Twist      : ',ttwist
      write(SO,'(1a,1pe20.6)')'Bend       : ',tbend
      write(SO,'(1a,1pe20.6)')'K 24       : ',tk_24
      write(SO,'(1a,1pe20.6)')'Field      : ',tfield
      write(SO,'(1a,1pe20.6)')'Total      : ',
     >                  tsplay+ttwist+tbend+tk_24+tfield
      write(SO,*)
      call flush(SO)
c
c
      close(IOUT)
      close(EOUT)
c
c...if this is the first time through write out movable file
c
      if (id .eq. 0) then
        write(filename,'(2a)')
     >        DIRECTORY(1:length(DIRECTORY)),'/movable.dat'
        open(unit = MOUT, file = filename, status = 'unknown',
     >                                                 err = 500)
        do i = 1 , size(1)
          do j = 1 , size(2)
            do k = 1 , size(3)
              write(MOUT,'(l1)')movable(i,j,k)
            enddo
          enddo
        enddo
        close(MOUT)
      endif
c
      return
c
400   stop 'file id error in output'
c
500   stop 'file opening error in output'
c                       
      end               
