c File:         %M%     
c Last Update:  %E% %U% 
c Version:      %R%.%L% 

c
c...Setup routine for the orient array
c
      subroutine setup(orient,size,movable,nmov,dims,geometry,ierr)
c
      implicit none
c
c...passed variables
c
      integer            size(3)
      double precision   orient(3,size(1),size(2),size(3))
      logical            movable(size(1),size(2),size(3))
      integer            dims
      integer            nmov
      character*(*)      geometry
      integer            ierr
c
c...local variables
c
      integer            i,j,k
      double precision   x,y,z,r, ROOT2
      double precision   phi, alpha, tilt, theta
      double precision   epsilon, norm, radiussqr
      double precision   vtmp(3)
      integer            size_max
      character*80       filename
      integer            length
c
#include "pi.inc"
#include "params.inc"
#include "files.inc"
c
c...start of executable code
c
      ROOT2 = sqrt(2.0d0)
      ierr = 0
      nmov = 0
      vtmp(1) = 1.0d0
      vtmp(2) = 0.0d0
      vtmp(3) = 0.0d0
c
      do k = 1 , size(3)
        z = dble( 2 * k - size(3) - 1 ) / dble( size(3) - 1 )
        do j = 1 , size(2)
          y = dble( 2 * j - size(2) - 1 ) / dble( size(2) - 1 )
          do i = 1 , size(1)
            x = dble( 2 * i - size(1) - 1 ) / dble( size(1) - 1 )
c
            if (geometry .eq. 'ESCAPED-1') then
              r = sqrt(x*x + y*y)
              orient(1,i,j,k) = x*(sin(PI*r/2.0d0))
              orient(2,i,j,k) = -y*(sin(PI*r/2.0d0))
              orient(3,i,j,k) = cos(PI*r/2.0d0)
c
c...hedgehog point defects
c
            elseif(geometry .eq. 'MONO_FIXED') then
              if (i.eq.1 .or. i.eq.size(1) .or.
     >            j.eq.1 .or. j.eq.size(2) .or.
     >            k.eq.1 .or. k.eq.size(3)) then
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
                movable(i,j,k) = .false.
              else
                call isotropic(90.0d0, vtmp,
     >                 orient(1,i,j,k),dims,ierr)
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
            elseif (geometry .eq. 'HEDGEHOG') then
              r = sqrt(x * x + y * y + z * z)
              orient(1,i,j,k) = x/r
              orient(2,i,j,k) = y/r
              orient(3,i,j,k) = z/r
              if (r .lt. 0.00000001) then
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              elseif (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...foyer point defects
c
            elseif (geometry .eq. 'FOYER') then
              r = sqrt(x * x + y * y + z * z)
              orient(1,i,j,k) = (x + y) / (ROOT2*r)
              orient(2,i,j,k) = (-x + y) /  (ROOT2*r)
              orient(3,i,j,k) = z/r
              if (r .lt. 0.00000001) then
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              elseif (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...centre point defects
c
            elseif (geometry .eq. 'CENTRE') then
              r = sqrt(x * x + y * y + z * z)
              orient(1,i,j,k) = y/r
              orient(2,i,j,k) = -x/r
              orient(3,i,j,k) = z/r
              if (r .lt. 0.00000001) then
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              elseif (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...COL_FOYER point defects
c
            elseif (geometry .eq. 'COL_FOYER') then
              r = sqrt(x * x + y * y + z * z)
              orient(1,i,j,k) = (-x + y) / (ROOT2*r)
              orient(2,i,j,k) = (-x - y) / (ROOT2*r)
              orient(3,i,j,k) = z/r
              if (r .lt. 0.00000001) then
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              elseif (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...COL point defects
c
            elseif (geometry .eq. 'COL') then
              r = sqrt(x * x + y * y + z * z)
              orient(1,i,j,k) = x/r
              orient(2,i,j,k) = y/r
              orient(3,i,j,k) = -z/r
              if (r .lt. 0.00000001) then
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              elseif (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
             
c
c...concentric cylinder case, concentric starting conditions
c
            elseif (geometry .eq. 'CONCENTRIC_CYLINDER') then
              r = sqrt(x * x + y * y)
              orient(1,i,j,k) = -y/r
              orient(2,i,j,k) = x/r
              orient(3,i,j,k) = 0.0d0
              if (r.lt.0.00001) then
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              elseif (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...concentric cylinder, twist escaped
c
            elseif (geometry .eq. 'CONCENTRIC_CYLINDER_TE') then
              r = sqrt(x * x + y * y)
              orient(1,i,j,k) = -y/r
              orient(2,i,j,k) = x/r
              orient(3,i,j,k) = 0.0d0
              if (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                if (r.gt.0.00001) then
                  orient(1,i,j,k) = y/sqrt(x*x+y*y)*sind(90.0d0*r)
                  orient(2,i,j,k) = -x/sqrt(x*x+y*y)*sind(90.0d0*r)
                  orient(3,i,j,k) = cosd(90.0d0*r)
                else
                  orient(1,i,j,k) = 0.0d0
                  orient(2,i,j,k) = 0.0d0
                  orient(3,i,j,k) = 1.0d0
                endif
                nmov = nmov + 1
              endif
c
c...concentric cylinder, planar bipolar
c
            elseif (geometry .eq. 'CONCENTRIC_CYLINDER_PB') then
              r = sqrt(x * x + y * y)
              orient(1,i,j,k) = -y/r
              orient(2,i,j,k) = x/r
              orient(3,i,j,k) = 0.0d0
              if (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                orient(1,i,j,k) = ((-1 + x)/((-1 + x)**2 + y**2)**(3/2)-
     >     (1 + x)/((1 + x)**2 + y**2)**(3/2))/
     >   Sqrt(((-1 + x)/((-1 + x)**2 + y**2)**(3/2) -
     >        (1 + x)/((1 + x)**2 + y**2)**(3/2))**2 +
     >     (y/((-1 + x)**2 + y**2)**(3/2)
     >                - y/((1 + x)**2 + y**2)**(3/2))**2)
                orient(2,i,j,k) =   (y/((-1 + x)**2 + y**2)**(3/2)
     >            - y/((1 + x)**2 + y**2)**(3/2))/
     >   Sqrt(((-1 + x)/((-1 + x)**2 + y**2)**(3/2) -
     >        (1 + x)/((1 + x)**2 + y**2)**(3/2))**2 +
     >     (y/((-1 + x)**2 + y**2)**(3/2)
     >        - y/((1 + x)**2 + y**2)**(3/2))**2)
                orient(3,i,j,k) = 0.0d0
                nmov = nmov + 1
              endif
c
c...concentric cylinder, random interior
c
            elseif (geometry .eq. 'CONCENTRIC_CYLINDER_R') then
              r = sqrt(x * x + y * y)
              orient(1,i,j,k) = -y/r
              orient(2,i,j,k) = x/r
              orient(3,i,j,k) = 0.0d0
              if (r.ge.1.0) then
                movable(i,j,k) = .false.
              else
                movable(i,j,k) = .true.
                call isotropic(90.0d0, vtmp,
     >                 orient(1,i,j,k),dims,ierr)
                nmov = nmov + 1
              endif
c
c...periodic boundaries, radomised monodomain interior
c
            elseif (geometry .eq. 'R_MONODOMAIN') then
100           continue
                call isotropic(90.0d0, vtmp,
     >                 orient(1,i,j,k),dims,ierr)
              if (abs(orient(2,i,j,k)) .lt. 0.75d0) goto 100
              movable(i,j,k) = .true.
              nmov = nmov + 1
c
c...periodic boundaries, monodomain interior
c
            elseif (geometry .eq. 'MONODOMAIN') then
              orient(1,i,j,k) = 1.0d0
              orient(2,i,j,k) = 0.0d0
              orient(3,i,j,k) = 0.0d0
              movable(i,j,k) = .true.
              nmov = nmov + 1
c
c...periodic boundaries, random interior
c
            elseif (geometry .eq. 'PERIODIC') then
                call isotropic(90.0d0, vtmp,
     >                 orient(1,i,j,k),dims,ierr)
              movable(i,j,k) = .true.
              nmov = nmov + 1
            elseif (geometry .eq. 'FREDBEND') then
              orient(1,i,j,k) = 1.0d0
              orient(2,i,j,k) = 0.0d0
              orient(3,i,j,k) = 0.0d0
              if (i.gt.1 .and. i.lt.size(1)) then
                movable(i,j,k) = .true.
                nmov = nmov + 1
              else
                movable(i,j,k) = .false.
              endif
            elseif (geometry .eq. 'FREDSPLAY') then
              orient(1,i,j,k) = 1.0d0
              orient(2,i,j,k) = 0.0d0
              orient(3,i,j,k) = 0.0d0
              if (k.gt.1 .and. k.lt.size(3)) then
                movable(i,j,k) = .true.
                nmov = nmov + 1
              else
                movable(i,j,k) = .false.
              endif
            elseif (geometry .eq. 'FREDSPLAY2') then
              if (k.gt.1 .and. k.lt.size(3)) then
                theta =(PI/2)*sin(PI*(k-1.0d0)/(size(3)-1.0d0))
                orient(1,i,j,k) = cos(theta)
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = sin(theta)
                movable(i,j,k) = .true.
                nmov = nmov + 1
              else
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
                movable(i,j,k) = .false.
              endif
            elseif (geometry .eq. 'TWIST') then
                theta = (PI * (k-1))/(20*(size(3)-1))
                orient(1,i,j,k) = cos(theta)
                orient(2,i,j,k) = sin(theta)
                orient(3,i,j,k) = 0.0d0
c                call isotropic(90.0d0, vtmp,
c     >                 orient(1,i,j,k),dims,ierr)
              if (k.gt.1 .and. k.lt.size(3)) then
                movable(i,j,k) = .true.
                nmov = nmov + 1
              else
                movable(i,j,k) = .false.
              endif
            elseif (geometry .eq. 'MEYER') then
              if (k .eq. 1 ) then
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
                movable(i,j,k) = .false.
              elseif(k .eq. size(3)) then
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
                movable(i,j,k) = .false.
              else
                theta = (PI * (k-1))/(2*(size(3)-1))
                orient(1,i,j,k) = cos(theta)
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = sin(theta)
c                call isotropic(90.0d0, vtmp,
c     >                 orient(1,i,j,k),dims,ierr)
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...planar plates parallel to x
c
            elseif (geometry .eq. 'PLANAR_PLATES') then
              if (k .eq. 1 .or. k .eq. size(3)) then
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
                movable(i,j,k) = .false.
              else
                call isotropic(90.0d0, vtmp,
     >                 orient(1,i,j,k),dims,ierr)
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...Pair of disclinations lines - 2D
c   Fixed boundaries
c
            elseif (geometry .eq. 'PAIR_FB') then
              if (abs(y) .lt. 0.5d0 .and. 
     >              abs(x) .lt. 0.5d0) then
                alpha = (y + 0.5) * 180.0
                orient(1,i,j,k) = cosd(alpha)
                orient(2,i,j,k) = sind(alpha)
                orient(3,i,j,k) = 0.0d0
              else
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
              endif   
              if (i .eq. 1 .or. i .eq. size(1) .or.
     >            j .eq. 1 .or. j .eq. size(2)) then
              movable(i,j,k) = .false.
                else
              movable(i,j,k) = .true.
                nmov = nmov + 1
              endif
c
c...Pair of disclinations lines - 2D
c   Periodic Boundary conditions
c
            elseif (geometry .eq. 'PAIR') then
              if (abs(y) .lt. 0.5d0 .and. 
     >              abs(x) .lt. 0.5d0) then
                alpha = (y + 0.5) * 180.0
                orient(1,i,j,k) = cosd(alpha)
                orient(2,i,j,k) = sind(alpha)
                orient(3,i,j,k) = 0.0d0
              else
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
              endif   
              movable(i,j,k) = .true.
              nmov = nmov + 1
            
c
c...twist wall loop parallel to XZ plane, periodic boundaries
c   monodomain parallel to y
c
            elseif (geometry .eq. 'TW_WALL_LOOP') then
              r = sqrt(x*x + z*z)
              if (r .gt. 0.3 .and.
     >             r .lt. 0.7) then
                alpha = 90.0 * (0.5 - r)/0.2
                theta = acosd(x/r)
                if (z .lt. 0.0d0) theta = 360 - theta
                orient(1,i,j,k) = -cosd(alpha)*sind(theta)
                orient(2,i,j,k) = sind(alpha)
                orient(3,i,j,k) = cosd(alpha)*cosd(theta)
                movable(i,j,k) = .true.
                nmov = nmov + 1
              else
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 1.0d0
                orient(3,i,j,k) = 0.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif   
c
c...wall loop parallel to XY plane, periodic boundaries
c   monodomain parallel to y
c
            elseif (geometry .eq. 'WALL_LOOP') then
              r = sqrt(x*x + y*y)
              if (r .gt. 0.3 .and.
     >             r .lt. 0.7) then
                alpha = 90.0 * (0.5 - r)/0.2
                orient(1,i,j,k) = cosd(alpha)
                orient(2,i,j,k) = sind(alpha)
                orient(3,i,j,k) = 0.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              else
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 1.0d0
                orient(3,i,j,k) = 0.0d0
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif   
c
c...loop parallel to XY plane, periodic boundaries
c   monodomain parallel to x
c
            elseif (geometry .eq. 'LOOP') then
              if (x*x + y*y .lt. 0.7 .and.
     >              abs(z) .lt. 0.5) then
                alpha = (z + 0.5) * 180.0
                orient(1,i,j,k) = cosd(alpha)
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = sind(alpha)
              else
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
              endif   
              movable(i,j,k) = .true.
              nmov = nmov + 1
c
c...loop parallel to XY plane, periodic boundaries
c   monodomain parallel to z
c
            elseif (geometry .eq. 'LOOP2') then
              if (x*x + y*y .lt. 0.7 .and.
     >              abs(z) .lt. 0.5) then
                alpha = (z + 0.5) * 180.0
                orient(1,i,j,k) = sind(alpha)
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = cosd(alpha)
              else
                orient(1,i,j,k) = 0.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 1.0d0
              endif   
              movable(i,j,k) = .true.
              nmov = nmov + 1
c
c...twist loop parallel to XY plane, periodic boundaries
c   monodomain parallel to x
c
            elseif (geometry .eq. 'TLOOP') then
              if (x*x + y*y .lt. 0.7 .and.
     >              abs(z) .lt. 0.5) then
                alpha = (z + 0.5) * 180.0
                orient(1,i,j,k) = cosd(alpha)
                orient(2,i,j,k) = sind(alpha)
                orient(3,i,j,k) = 0.0d0
              else
                orient(1,i,j,k) = 1.0d0
                orient(2,i,j,k) = 0.0d0
                orient(3,i,j,k) = 0.0d0
              endif   
              movable(i,j,k) = .true.
              nmov = nmov + 1
c
c...domain structure a la Tim Lemmon
c
            elseif (geometry .eq. 'LEMMON' .or.
     >         geometry .eq. 'LEMMON2') then
              alpha = 68.0d0
              tilt = 20.0d0
c
c...top
c             
              if (k .eq. size(3)) then
                if (x.gt.-0.5d0 .and. x.lt.0.5d0) then
                  orient(1,i,j,k) = cosd(tilt)*cosd(alpha)
                  orient(2,i,j,k) = cosd(tilt)*sind(alpha)
                  orient(3,i,j,k) = -sind(tilt)
                else
                  orient(1,i,j,k) = cosd(tilt)*cosd(alpha)
                  orient(2,i,j,k) = -cosd(tilt)*sind(alpha)
                  orient(3,i,j,k) = -sind(tilt)
                endif
                movable(i,j,k) = .false.
c
c...bottom
c             
              elseif (k .eq. 1) then
                if (y.gt.-0.5d0 .and. y.lt.0.5d0) then
                  orient(1,i,j,k) = cosd(tilt)*cosd(alpha)
                  orient(2,i,j,k) = cosd(tilt)*sind(alpha)
                  orient(3,i,j,k) = sind(tilt)
                else
                  orient(1,i,j,k) = cosd(tilt)*cosd(alpha)
                  orient(2,i,j,k) = -cosd(tilt)*sind(alpha)
                  orient(3,i,j,k) = sind(tilt)
                endif
                movable(i,j,k) = .false.
c
c...centre plane
c
              elseif (geometry .eq. 'LEMMON2' .and.
     >                   k .eq. (size(3) + 1) / 2 ) then
                  orient(1,i,j,k) = 1.0d0
                  orient(2,i,j,k) = 0.0d0
                  orient(3,i,j,k) = 0.0d0
                  movable(i,j,k) = .false.
c
c...interior
c
              else
                call isotropic(90.0d0, vtmp,
     >                 orient(1,i,j,k),dims,ierr)
                movable(i,j,k) = .true.
                nmov = nmov + 1
              endif   
            endif
c
          enddo
        enddo
      enddo
c
      if (geometry .eq. 'FILE') then
c
c...read in vector data
c
        open(unit = IIN2, file = GEOMFILE, status = 'old', err = 500)
c
        do i = 1 , size(1)
          do j = 1 , size(2)
            do k = 1 , size(3)
              read(IIN2,'(3f9.5)') x, y, z
              norm = sqrt ( x*x + y*y + z*z )
              orient(1,i,j,k) = x / norm
              orient(2,i,j,k) = y / norm
              orient(3,i,j,k) = z / norm
            enddo
          enddo
        enddo
        close(IIN2)
c
c...read in movable data
c
        open(unit = IIN2, file = MOVEFILE, status = 'old', err = 500)
        do i = 1 , size(1)
          do j = 1 , size(2)
            do k = 1 , size(3)
              read(IIN2,'(1l)')movable(i,j,k)
              if (movable(i,j,k)) nmov = nmov + 1
            enddo
          enddo
        enddo
      endif
c
      return
c
500   stop
c
      end
