! Hydrogen desorption 
	program Hdesorption
      implicit none
      interface
         subroutine FDM(Hl,Hs,D,dz,dt,grid)
            integer :: i, grid
            real(8), allocatable, dimension(:) :: Hl,Hl_update
            real(8) :: Hs,D,dz,dt
         end subroutine FDM
         subroutine FDM_s(Hl,Hs,D,dz,dt,z,grid)
            integer :: i, grid
            real(8), allocatable, dimension(:) :: Hl, z, Hl_update
            real(8) :: Hs,D,dz,dt
         end subroutine FDM_s
         subroutine local_eq(Hl,Ht,Nl,Nt,k,T)
            real(8) :: Hl,Ht,Nl,Nt,Eb,k,T
            real(8) :: y1,y2,y3,gl,gt,total
         end subroutine local_eq
         subroutine kinetic(Hl,Ht,Nl,Nt,Q,Eb,dt,T)
	      real(8) :: Hl,Nl,Ht,Nt,Q,Eb,dt,T
	      real(8) :: Ht_up,Hl_up, Ptl, Plt
            real(8) :: prob
         end subroutine kinetic
      end interface
      integer :: i,icharge,iage,ishape,mode,iter,grid
      real(8), allocatable, dimension(:) :: Hl, z, Ht1, Ht2, Ht3, area_f
	real(8) :: Hs,dz,dt,D0,Q,l,D,Nl
	real(8) :: avel,ave1,ave2,ave3
	real(8) :: Eb1,Eb2,Eb3,Nt1,Nt2,Nt3
	real(8) :: k1,k2,k3
	real(8) :: ch_time,ag_time,des_time,T,Tend,dTdt,time,time1
      real(8), parameter :: R=8.3144621d0 !Gas constant J/mol
      real(8), parameter :: Mu=1d13 !Prefactor
      real(8), parameter :: Na=6.02214129d23 !Avogadro mol^-1
      real(8), parameter :: mass=55.845 !Fe atomic weight
      real(8), parameter :: Vm=7.09e-6
!
	namelist /specimen/ D0,Q,l,Hs,Eb1,Eb2,Eb3,Nl,Nt1,Nt2,Nt3
	namelist /analysis/ mode,ch_time,ag_time,des_time,dt,T,Tend,dTdt
	namelist /option/ icharge, iage, ishape,grid
! Read input file "in.txt"
      open(unit=1,file='in.txt',status='old')
      read(1,specimen)
      read(1,analysis)
      read(1,option)
      close(1)
! Allocation of Hl, z, Ht1, Ht2, Ht3, area_f
      allocate(Hl(grid))
      allocate(z(grid))
      allocate(Ht1(grid))
      allocate(Ht2(grid))
      allocate(Ht3(grid))
      allocate(area_f(grid))
! Initialization of all arrays
      Hl=0d0
      z=0d0
      Ht1=0d0
      Ht2=0d0
      Ht3=0d0
      area_f=0d0
      time=0d0
      time1=0d0
!
	dz=l/grid
	z(1)=dz/2
	do i=2,grid
          z(i)=z(i-1)+dz
      enddo
      d=d0*exp(-Q/R/T)
      do while (dt>=(dz*dz/3/d)) !.ge.
          dt=dt/2
          print *, 'Too large dt_FDM 1'
      enddo
      if (ishape==1) then
          area_f(1)=dz*dz/l/l
          do i=2,grid
              area_f(i)=dz*dz*(i*i-(i-1)*(i-1))/l/l
          enddo
      endif
      open(unit=10,file='lattice.txt',status='unknown')
	Nl=Nl*Vm/mass/Na*1e6
      if (Nt1.gt.0) then
          k1=exp(Eb1/R/T)
          Nt1=Nt1*Vm/mass/Na*1e6
          open(unit=11,file='trap1.txt',status='unknown')
      endif
      if (Nt2.gt.0) then
          k2=exp(Eb2/R/T)
          Nt2=Nt2*Vm/mass/Na*1e6
          open(unit=12,file='trap2.txt',status='unknown')
      endif
      if (Nt3.gt.0) then
          k3=exp(Eb3/R/T)
          Nt3=Nt3*Vm/mass/Na*1e6
          open(unit=13,file='trap3.txt',status='unknown')
      endif
      do while (time<ch_time) !.lt.
          if (icharge==0) then
              open(unit=2,file='charging.txt',status='old')
              read(2,*) z
              read(2,*) Hl
              read(2,*) Ht1
              read(2,*) Ht2
              read(2,*) Ht3
              close(2)
              goto 10
          endif
          if (ishape==0) then
              call FDM(Hl,Hs,D,dz,dt,grid)
          else
              call FDM_s(Hl,Hs,D,dz,dt,z,grid)
          endif
          if (time1>=des_time) then !.ge.
              write(10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
              write(11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
              write(12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
              write(13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
              time1=0d0
          endif
          do i=1,grid
              if (Nt1.gt.0) call local_eq(Hl(i),Ht1(i),Nl,Nt1,k1,T)
              if (Nt2.gt.0) call local_eq(Hl(i),Ht2(i),Nl,Nt2,k2,T)
              if (Nt3.gt.0) call local_eq(Hl(i),Ht3(i),Nl,Nt3,k3,T)
          enddo
          time=time+dt
          time1=time1+dt
      enddo
      if (ishape==0) then
          avel=sum(Hl)/grid
          ave1=sum(Ht1)/grid
          ave2=sum(Ht2)/grid
          ave3=sum(Ht3)/grid
      else
          avel=sum(Hl*area_f)
          ave1=sum(Ht1*area_f)
          ave2=sum(Ht2*area_f)
          ave3=sum(Ht3*area_f)
      endif
      write(10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
      write(10,*) '------------------------------------'
      write(11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
      write(11,*) '------------------------------------'
      write(12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
      write(12,*) '------------------------------------'
      write(13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
      write(13,*) '------------------------------------'
!      
      open(unit=2,file='charging.txt',status='unknown')
      write(2,'(500E11.4)') z
      write(2,'(500E11.4)') Hl
      write(2,'(500E11.4)') Ht1
      write(2,'(500E11.4)') Ht2
      write(2,'(500E11.4)') Ht3
      write(2,'(F9.0,4E11.4)') time,avel,ave1,ave2,ave3
      close(2)
!
 10   time=0d0
      time1=0d0
      Hs=0d0
      do while (time.lt.ag_time)
          if (iage==0) then
              open(unit=3,file='aging.txt',status='old')
              read(3,*) z
              read(3,*) Hl
              read(3,*) Ht1
              read(3,*) Ht2
              read(3,*) Ht3
              close(3)
              goto 11
          endif
          if (ishape==0) then
              call FDM(Hl,Hs,D,dz,dt,grid)
          else
              call FDM_s(Hl,Hs,D,dz,dt,z,grid)
          endif
          if (time1>=des_time) then !.ge.
              write(10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
              write(11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
              write(12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
              write(13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
              time1=0d0
          endif
          do i=1,grid
              if (Nt3.gt.0) call local_eq(Hl(i),Ht3(i),Nl,Nt3,k3,T)
              if (Nt2.gt.0) call local_eq(Hl(i),Ht2(i),Nl,Nt2,k2,T)
              if (Nt1.gt.0) call local_eq(Hl(i),Ht1(i),Nl,Nt1,k1,T)
          enddo
          time=time+dt
          time1=time1+dt
      enddo
      if (ishape==0) then
          avel=sum(Hl)/grid
          ave1=sum(Ht1)/grid
          ave2=sum(Ht2)/grid
          ave3=sum(Ht3)/grid
      else
          avel=sum(Hl*area_f)
          ave1=sum(Ht1*area_f)
          ave2=sum(Ht2*area_f)
          ave3=sum(Ht3*area_f)
      endif
      write(10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
      write(10,*) '------------------------------------'
      write(11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
      write(11,*) '------------------------------------'
      write(12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
      write(12,*) '------------------------------------'
      write(13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
      write(13,*) '------------------------------------'
      open(unit=3,file='aging.txt',status='unknown')
      write(3,'(500E11.4)') z
      write(3,'(500E11.4)') Hl
      write(3,'(500E11.4)') Ht1
      write(3,'(500E11.4)') Ht2
      write(3,'(500E11.4)') Ht3
      write(3,'(F9.0,4E11.4)') time,avel,ave1,ave2,ave3
      close(3)
 11   time=0d0
      time1=0d0
      print *, '***** Start desorption *****'
      iter=0
      open(unit=20,file='results.txt',status='unknown')
      write(20,'(F9.2,E11.4)') (T-273), (avel+ave1+ave2+ave3)
      do while (T.le.Tend) 
          if (ishape==0) then
              call FDM(Hl,Hs,D,dz,dt,grid)
          else
              call FDM_s(Hl,Hs,D,dz,dt,z,grid)
          endif
          if (time1>=des_time) then !.ge.
              write(10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
              write(11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
              write(12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
              write(13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
              if (ishape==0) then
                  avel=sum(Hl)/GRID
                  ave1=sum(Ht1)/GRID
                  ave2=sum(Ht2)/GRID
                  ave3=sum(Ht3)/GRID
              else
                  avel=sum(Hl*area_f)
                  ave1=sum(Ht1*area_f)
                  ave2=sum(Ht2*area_f)
                  ave3=sum(Ht3*area_f)
              endif
              !write(20,*) (T-273), avel,ave1,ave2,ave3
              write(20,'(F9.2,E11.4)') T-273,avel+ave1+ave2+ave3
              time1=0d0
          endif
          do i=1,grid
              if (mode.eq.0) then
                  if (Nt3.gt.0) call kinetic(Hl(i),Ht1(i),Nl,Nt3,Q,Eb3,dt,T)
                  if (Nt2.gt.0) call kinetic(Hl(i),Ht2(i),Nl,Nt2,Q,Eb2,dt,T)
                  if (Nt1.gt.0) call kinetic(Hl(i),Ht1(i),Nl,Nt1,Q,Eb1,dt,T)
              else
                  if (Nt3.gt.0) call local_eq(Hl(i),Ht3(i),Nl,Nt3,k3,T)
                  if (Nt2.gt.0) call local_eq(Hl(i),Ht2(i),Nl,Nt2,k2,T)
                  if (Nt1.gt.0) call local_eq(Hl(i),Ht1(i),Nl,Nt1,k1,T)
              endif
          enddo
          do while (dt>=(dz*dz/3/D)) !.ge.
              dt = dt*0.5
              print *, 'Too large dt_FDM 2'
          enddo
          T=T+dTdt*dt
          time=time+dt
          time1=time1+dt
          iter=iter+1
          if (mod(iter,400000).eq.0) write(*,'(F11.2)') T-273
          d=d0*exp(-Q/R/T)
          if (Nt1.gt.0) k1=exp(Eb1/R/T)
          if (Nt2.gt.0) k2=exp(Eb2/R/T)
          if (Nt3.gt.0) k3=exp(Eb3/R/T)
      enddo
      if (ishape==0) then
          avel=sum(Hl)/GRID
          ave1=sum(Ht1)/GRID
          ave2=sum(Ht2)/GRID
          ave3=sum(Ht3)/GRID
      else
          avel=sum(Hl*area_f)
          ave1=sum(Ht1*area_f)
          ave2=sum(Ht2*area_f)
          ave3=sum(Ht3*area_f)
      endif
      write(10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
      write(10,*) '------------------------------------'
      write(11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
      write(11,*) '------------------------------------'
      write(12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
      write(12,*) '------------------------------------'
      write(13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
      write(13,*) '------------------------------------'
      open(unit=4,file='desorption.txt',status='unknown')
      write(4,'(500E11.4)') z
      write(4,'(500E11.4)') Hl
      write(4,'(500E11.4)') Ht1
      write(4,'(500E11.4)') Ht2
      write(4,'(500E11.4)') Ht3
      write(4,'(F9.0,4E11.4)') time,avel,ave1,ave2,ave3
      close(4)
      end program Hdesorption
!-------------------------------------------------------------------------------------
	subroutine FDM(Hl,Hs,D,dz,dt,grid)
      implicit none
      integer :: i, grid
      real(8), allocatable, dimension(:) :: Hl,Hl_update
      real(8) :: Hs,D,dz,dt
! Allocate temp array
      allocate(Hl_update(grid))
!
      Hl_update=0d0
      do i=1,grid
          if (i.eq.1) then
              Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hl(i+1))
          else if (i.eq.grid) then
              Hl_update(i)=Hs
              !Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hs )
          else
              Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i-1)-2*Hl(i)+Hl(i+1) )
          endif
      enddo
      do i=1,grid
          Hl(i)=Hl_update(i)
      enddo
      deallocate(Hl_update)
      end subroutine FDM
!-------------------------------------------------------------------------------------
      subroutine FDM_s(Hl,Hs,D,dz,dt,z,grid)
      implicit none
      integer :: i, grid
      real(8), allocatable, dimension(:) :: Hl, z, Hl_update
      real(8) :: Hs,D,dz,dt
! Allocate temp array
      allocate(Hl_update(grid))
!
      Hl_update=0d0
      do i=1,grid
          if (i.eq.1) then
              Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hl(i+1) )+D*dt/dz/z(i)*( Hl(i+1)-Hl(i))
          else if (i.eq.grid) then
              Hl_update(i)=Hs
              !Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hs )+D*dt/dz/z(i)*( Hs-Hl(i))
          else
              Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i-1)-2*Hl(i)+Hl(i+1) )+D*dt/dz/z(i)*( Hl(i+1)-Hl(i) )
          endif
      enddo
      do i=1,grid
          Hl(i)=Hl_update(i)
      enddo
      deallocate(Hl_update)
      end subroutine FDM_s
!-------------------------------------------------------------------------------------
	subroutine local_eq(Hl,Ht,Nl,Nt,k,T)
      implicit none
      real(8) :: Hl,Ht,Nl,Nt,Eb,k,T
      real(8) :: y1,y2,y3,gl,gt,total
!
      total=Hl+Ht
      if (total<=1e-20) return!goto 60 !.le.
      gl=Hl/Nl
      gt=Ht/Nt
      y1=Nt
      y2=-1*(total+Nl/k+Nt)
      y3=total
      gt=(-y2-dsqrt(y2**2-4*y1*y3))/2/y1
      Ht=gt*Nt
      Hl=total-Ht
      if ((total-Ht)<=1e-20) Hl=0.0 !.le.
 60   end subroutine local_eq
!-------------------------------------------------------------------------------------
	subroutine kinetic(Hl,Ht,Nl,Nt,Q,Eb,dt,T)
      implicit none
	real(8) :: Hl,Nl,Ht,Nt,Q,Eb,dt,T
	real(8) :: Ht_up,Hl_up, Ptl, Plt
      real(8) :: prob
!
50    Plt=prob(Nt,Nl,Ht,Hl,Q,T,dt)
      Ptl=prob(Nl,Nt,Hl,Ht,Eb+Q,T,dt)
      Hl_up=Ht*Ptl+Hl*(1-Plt)
      Ht_up=Hl*Plt+Ht*(1-Ptl)
      if (Ht_up<0 .or. Ht_up>Nt) then
          dt=dt/2
          print *, 'Too large dt (kinetic)'
          write(4,'(F9.2,E11.4,a)') T-273,dt,'  2'
          goto 50
      endif
      Hl=Hl_up
      Ht=Ht_up
      end subroutine kinetic
!-------------------------------------------------------------------------------------
	real(8) function prob(Nt,Nl,Ht,Hl,Q,T,dt)
      implicit none
      real(8) :: Nt,Nl,Ht,Hl,Q,k,T,dt
      real(8), parameter :: R=8.3144621d0 !Gas constant J/mol
      real(8), parameter :: Mu=1d13 !Prefactor
!      
      k=exp(-Q/R/T)
      prob=k*(Nt-Ht)/(Nt+Nl-(Ht+Hl))
      prob=1-(1-prob)**(Mu*dt)
      return
      end function prob
!-------------------------------------------------------------------------------------