/*  This routine is from "Numerical Recipes in C."  */

/********** copy this part into your pgm ************/

/*  cc <file.c> -o <file> -lm  */

#include <math.h>

float rnd()
{
	return( (random() % 65536)/65536.0 );
}

float gasdev()
{
	static int		iset = 0;
	static double	gset;
	double			fac, r, v1, v2;

	if( iset == 0 )   {
		do {
			v1 = 2.0*rnd() - 1.0;
			v2 = 2.0*rnd() - 1.0;
			r = v1*v1 + v2*v2;
		} while ( r >= 1.0 );
		fac = sqrt( -2.0*log(r)/r );
		gset = v1*fac;
		iset = 1;
		return v2*fac;
	} else   {
		iset = 0;
		return gset;
	}
}

/***************** distribution demo ******************/

main()
{
	long		i;
	int			j, seed, dist[81];
	double		a, max;

	printf(" please supply an integer rnd seed: " );
	scanf( "%d", &seed );
	srandom( seed );
	for( i=0; i<81; i++ )
		dist[i] = 0.0;
	printf( "Will generate 10,000 numbers.\n\n" );
	for( i=0; i<10000; i++ )   {
		if( !(i%1000) ) printf("%d\n", i);
		a = gasdev();
		if( (a>-4.0) || (a<4.0) )
			dist[ (int) ((a+4.0)*10) ]++;
		else
			printf(".");
		} printf("\n");
	max = dist[40]/80.0;
	for( i=0; i<81; i++ )   {
		printf( "x: %f", (double)(i)/10.0-4.0 ); 
		for( j=0; j<dist[i]/max; j++ )
			printf("*");
		printf("\n");
	}
}

