/*	Version 14			*/
/* My routines as of June 28th 1989 Sept 26th 1990 sept 27 1991 */
/* work needed on line 997 */

#include "r.h"
/* #include "nrutil.c" Cut out [again?] Jan 23 -- include this using makefile */

/***    Index    ***/

/* random */
/* basic input */ 
/* matrix allocation */
/* matrix construction */
/* output */
/* vectors */
/* vector operations */
/* input */
/* maths */
/* crash */
/* file handling routines */
/* silly functions */

/*****************************/
/*      THE FUNCTIONS        */
/*     my own functions      */
/*****************************/
#define TINY	1e-6

/* random */

double 	l_random_1()
{
	return(drand48());
}

double 	l_random(t,s)
	double s;
	int t;
{
	switch(t){
		case(1):
			return(drand48()*s);
			break;
		case(2):
			return(drand48()*2*s-s);
			break;
		default:
			crash("error in random");
			break;
	}
}

double 	gaussian(sigma)
	double sigma;
{
	return(gaussian01()*sigma);
}

double 	cheap_gaussian(sigma)
	double sigma;
{
	int i;
	int num=10;
	double temp=0;

	for(i=1;i<=num;i++) temp += l_random_1()-0.5;
	return(temp*sigma/sqrt((double)(num)/12.0));
}

double gaussian01()
{
        static int              iset = 0;
        static double   gset;
        double                  fac, r, v1, v2;

        if( iset == 0 )   {
                do {
                        v1 = 2.0*l_random_1() - 1.0;
                        v2 = 2.0*l_random_1() - 1.0;
                        r = v1*v1 + v2*v2;
                } while ( r >= 1.0 );
                fac = sqrt( -2.0*log(r)/r );
                gset = v1*fac;
                iset = 1;
                return v2*fac;
        } else   {
                iset = 0;
                return gset;
        }
}

double 	gauss(x,sigma) /* not a random routine. this returns density */ 
	double x,sigma;
{
	return( exp( -(x*x)/(2*sigma*sigma) )/(STPI*sigma) );
}

double 	robust_gauss(x,sigma,v,out)  
	double x,sigma,v;
	double	*out; /* this flag is set high if x is an outlier */ 
{
	double	u;

	u=fabs(x/sigma);
	if (u > v){
		*out = 1.0;
		return( exp( v*v/2.0 - v*u )/(STPI*sigma) );
	} else {
		*out = 0.0;
		return( exp( -u*u/2.0 )/(STPI*sigma) );
	}
}

double 	gauss_window(mu,sigma,min,max) /* not a random routine. this returns */ 
		/*  fractional partition function to divide gauss() by */
	double mu,sigma,min,max;
{
	return( 1.0 - (erfc((max-mu) /sigma) + erfc(( mu - min) /sigma) )  );
}

double 	robust_z(v)
	double	v;
{
	return( 1.0 + 2.0*(gauss(v,1.0)/v - erfc(v)) );
}

double	erfc(x) /* the area under the gaussian standard curve from x up to 
		infty.  
		Note NR defines erfc to be twice this. */ 
	double	x; 
/* copied from NR */ 
{
        double t,z,ans;

        z=fabs(x/sqrt(2.0));
        t=1.0/(1.0+0.5*z);
        ans=t*exp(-z*z-1.26551223+t*(1.00002368+t*(0.37409196+t*(0.09678418+
                t*(-0.18628806+t*(0.27886807+t*(-1.13520398+t*(1.48851587+
                t*(-0.82215223+t*0.17087277)))))))))/2.0;
        return x>=0.0 ?  ans : 1.0 - ans;
}

double 	background(u,a) /* not a random routine - gives density */ 
	double u,a;	/* NB the returned value should be divided by delta 
				for normalisation */
{
	if ( fabs(a) < TINY ) return (1);
	else return ( a * exp( a*u )/(exp(a)-1) );
}

double 	ran_back(a) /*  a random routine -- generates from exponential on 0-1 */ 
	double a;	
{
	if ( fabs(a) < TINY ) return (l_random_1());
	else return 
	( ( (a-2.0) + sqrt((a-2.0)*(a-2.0) + 8.0*a*l_random_1()) )/(2.0*a) ); 
		/* using linear approximation for density */
}

double 	randmr(m,r)
	double m,r;
{
	double u;
	u=m-r/2;
	
	return(u+drand48()*r);
}

int 	l_random_bit(b)
	double b;
{
	if (l_random_1() >b )
		return(0);
	else
		return(1);
}

int 	l_random_int(i,p)
	double	*p;
	int	i;
{	/* This returns an integer between 1 and i, 
		with probabilities given by the vector p[] */
	double	b;
	int	j;
	b=l_random_1();

	for(j=1;j<=i && (b>0.0);j++) b-=p[j];
	j--;
	return(j);
}

l_random_ud_bit(b)
	double b;
{
	if (l_random_1() >b )
		return(-1);
	else
		return(1);
}

double	flip1d(d,b)	/* BIT - FLIP (1/0) */
	double d,b;
{
	if (l_random_1() >b )
		return(d);
	else
		return(1.0-d);
}

double	flip2d(d,b)	/* BIT - FLIP (1/-1) */
	double d,b;
{
	if (l_random_1() >b )
		return(d);
	else
		return(-d);
}

void 	l_randomise(seed)
	long 	seed; /* randomisation variable */
{
	srand48(seed);
}

void 	randomise(seed)
	long 	seed; /* randomisation variable */
{
	srand48(seed);
}

/* basic input */ 

void 	pause_for_return()
{
	int c;

	printf( "press return to continue" );
	do{}while((c=getchar())!=10);
}

int 	yes_or_no()
{
	int c,d;
	
	c=getchar();
	if (c!=10) do{}while((d=getchar())!=10);
	switch(c){
		case(10): case (EOF): /* RETURN KEY */ 
			return(0);
			break;
		case 'y': case 'Y': /* y */ 
			return(1);
			break;
		case 'n': case 'N': /* n */ 
			return(0);
			break;
		default:
			return(0);
			break;
	}
}

int 	respond()
{
	int c,d;
	
	printf( "press return to continue or choose an option " );
	c=getchar();
	if (c!=10) do{}while((d=getchar())!=10);
	switch(c){
		case(10): case (EOF): /* RETURN KEY */ 
			return(0);
			break;
		case 'y': case 'Y': /* y */ 
			return(1);
			break;
		case 'n': case 'N': /* n */ 
			return(0);
			break;
		case '0': case '1': case '2': case '3': 
		case '4': case '5': case '6': case '7': 
		case '8': case '9':  
			return(c-'0');
			break;
		case 'h': case 'H': /* h = HELP OPTION */ 
			return(9);
			break;
		case 'q': case 'Q': /* q = Quit OPTION */ 
			return(0);
			break;
		case 'a': case 'A':  
			return(11);
			break;
		case 'b': case 'B':  
			return(12);
			break;
		case 'c': case 'C':  
			return(13);
			break;
		case 'd': case 'D':  
			return(14);
			break;
		default:
			debug(c+11-'a');
			return(c+11-'a');
			break;
	}
	if (c!=10) {debug(12);c=getchar();}
}

/* matrix allocation */

double ***dmatrix3(l1,h1,l2,h2,l3,h3)
	int l1,h1,l2,h2,l3,h3;
{
	double ***c;
	int s1,i;
	
	s1=h1-l1+1;
	
	c=(double ***) malloc((unsigned) s1*sizeof(double **)) - l1;
	for (i=l1;i<=h1;i++)
		c[i]=dmatrix(l2,h2,l3,h3);
	return c;
}

float ***fmatrix3(l1,h1,l2,h2,l3,h3)
	int l1,h1,l2,h2,l3,h3;
{
	float ***c;
	int s1,i;
	
	s1=h1-l1+1;
	
	c=(float ***)malloc((unsigned) s1*sizeof(float **)) - l1;
	for (i=l1;i<=h1;i++)
		c[i]=matrix(l2,h2,l3,h3);
	return c;
}

int ***imatrix3(l1,h1,l2,h2,l3,h3)
	int l1,h1,l2,h2,l3,h3;
{
	int ***c;
	int s1,i;
	
	s1=h1-l1+1;
	
	c=(int ***)malloc((unsigned) s1*sizeof(int **)) - l1;
	for (i=l1;i<=h1;i++)
		c[i]=imatrix(l2,h2,l3,h3);
	return c;
}

int ***ipyramid(l1,h1,h2,h3) /* resolution0 .... max_res, size of lowest
				rectangle 0...h2 * 0...h3 */
	int l1,h1,h2,h3;
{
	int ***c;
	int s1,i,sq_size;
	
	s1=h1-l1+1;
	
	c=(int ***)malloc((unsigned) s1*sizeof(int **)) - l1;
	for (i=l1,sq_size=1;i<=h1;i++,sq_size*=2)
		c[i]=imatrix(0,(h2+1)/sq_size-1,0,(h3+1)/sq_size-1);
	return c;
}

double ***dpyramid(l1,h1,h2,h3) /* resolution0 .... max_res, size of lowest
				rectangle 0...h2 * 0...h3 */
	int l1,h1,h2,h3;
{
	double ***c;
	int s1,i,sq_size;
	
	s1=h1-l1+1;
	
	c=(double ***)malloc((unsigned) s1*sizeof(double **)) - l1;
	for (i=l1,sq_size=1;i<=h1;i++,sq_size*=2)
		c[i]=dmatrix(0,(h2+1)/sq_size-1,0,(h3+1)/sq_size-1);
	return c;
}

unsigned char ***cmatrix3(l1,h1,l2,h2,l3,h3)
	int l1,h1,l2,h2,l3,h3;
{
	unsigned char ***c;
	int s1,i;
	
	s1=h1-l1+1;
	
	c=(unsigned char ***)malloc((unsigned) s1*sizeof(unsigned char **)) - l1;
	for (i=l1;i<=h1;i++)
		c[i]=cmatrix(l2,h2,l3,h3);
	return c;
}

unsigned char **cmatrix(nrl,nrh,ncl,nch)
int nrl,nrh,ncl,nch;
{
	int i;
	unsigned char	**m;

	m=(unsigned char **)malloc((unsigned) (nrh-nrl+1)*sizeof(unsigned char*));
	if (!m) nrerror("allocation failure 1 in cmatrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(unsigned char *)malloc((unsigned) (nch-ncl+1)*sizeof(unsigned char));
		if (!m[i]) nrerror("allocation failure 2 in cmatrix()");
		m[i] -= ncl;
	}
	return m;
}

void free_cmatrix(m,nrl,nrh,ncl,nch)
unsigned char **m;
int nrl,nrh,ncl,nch;
{
        int i;
 
        for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
        free((char*) (m+nrl));
}

double ****dmatrix4(l1,h1,l2,h2,l3,h3,l4,h4)
	int l1,h1,l2,h2,l3,h3,l4,h4;
{
	double ****c;
	int s1,i;
	
	s1=h1-l1+1;
	
	c=(double ****)malloc((unsigned) s1*sizeof(double ***)) - l1;
	for (i=l1;i<=h1;i++)
		c[i]=dmatrix3(l2,h2,l3,h3,l4,h4);
	return c;
}

/* matrix construction */

double constructdmatrixPOST (M,NP,ca,post)
	int NP;
	double **M;
	double ca,*post; 
{
	int i,j;
	double c,d=0;
	double div=0;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++){
        		d+=(c=post[i]*(M[i][j]= post[j]*(NP + ca - fabs((double)(i-j)))));
  /*      		pd(c/(sqrt(post[i]*post[j])),42); */
        		div+=post[i]*post[j];
        	}
    /*    	newline(); */
        } 
        return (d/div);
}

void postmultiplydmatrix (M,l1,h1,l2,h2,post)
	double 	**M;
	int 	l1,h1,l2,h2;
	double 	*post; 
{
	int i,j;
	
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
        		M[i][j]*= post[j-l2];
}

void premultiplydmatrix (M,l1,h1,l2,h2,p)
	double 	**M;
	int 	l1,h1,l2,h2;
	double 	*p; 
{
	int i,j;
	
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
        		M[i][j]*= p[i-l1];
}

void ppmultiplydmatrix (M,l1,h1,l2,h2,p)
	double 	**M;
	int 	l1,h1,l2,h2;
	double 	*p; 
{
	int i,j;
	
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
        		M[i][j]*= p[j-l2]*p[i-l1];
}

void addtodmatrix (M,l1,h1,l2,h2,p)
	double 	**M;
	int 	l1,h1,l2,h2;
	double 	p; 
{
	int i,j;
	
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
        		M[i][j]+= p;
}

void clipdmatrix (M,l1,h1,l2,h2,p,q)
	double 	**M;
	int 	l1,h1,l2,h2;
	double 	p,q; 
{
	int i,j;
	
	for (i=l1; i<=h1; i++){
		for (j=l2; j<=h2; j++){
        		if (M[i][j] < p) M[i][j] = p;
			else if (M[i][j] > q ) M[i][j] = q;
		}
	}
}

void invertdmatrix (M,l1,h1,l2,h2,p)
	double 	**M;
	int 	l1,h1,l2,h2;
	double 	p; 
{
	int i,j;
	
	p*=2.0;
	for (i=l1; i<=h1; i++){
		for (j=l2; j<=h2; j++){
        		M[i][j] = p - M[i][j];
		}
	}
}

void multiplydmatrix (M,l1,h1,l2,h2,p)
	double 	**M;
	int 	l1,h1,l2,h2;
	double 	p; 
{
	int i,j;
	
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
        		M[i][j]*= p;
}

void 	constructfmatrix (M,NP,ca)
	int NP;
	float **M;
	float ca; 
{
	int i,j;
		
	for (i=0;i<=NP-1;i++)
        	for (j=0;j<=NP-1;j++)
        		M[i][j]= (float) NP - fabs((float)(i-j))+ca;
}

void typeindmatrix (b,l1,h1,l2,h2)
	double 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j;

	printf( "please type matrix\n" );
	for (i=l1; i<=h1-1; i++)
		for (j=l2; j<=h2; j++)
			inputd(&b[i][j]); /* This is all a trick to obtain clearscan at the last read-in */
	for (j=l2; j<=h2-1; j++)
		inputd(&b[i][j]);
	inputrd(&b[i][j]);
}

void enterdmatrix (b,l1,h1,l2,h2)
	double 	**b;
	int 	l1,h1,l2,h2;
{
	int 	i,u,n;
	double 	junkd,junkd2;
	char 	junks[50];
	double 	*junkdv;
	
	printf( "choose matrix type\n" );

	printf( "1 	hand-typed\n" );
	printf( "2 	read in from file\n" );
	printf( "3 	combination of I and J\n" );
	printf( "4 	linear Toeplitz matrix\n" );
	printf( "5 	linear Toeplitz matrix + k2\n" );
	printf( "6 	Toeplitz matrix\n" );
	printf( "7 	Toeplitz matrix + k2\n" );
	printf( "8 	constant \n" );
	printf( "a 	random 0 <-> 1\n" );
	printf( "b 	random -1 <-> 1\n" );
	printf( "c 	random one-sided\n" );
	printf( "d 	random symmetrical\n" );
	printf( "Return	hand-typed \n" );
	switch(u=respond()){
		case(0):
		case(1):
			typeindmatrix(b,l1,h1,l2,h2);
			break;
		case(2):
			printf("enter file name - ");
			scanf("%s", junks);
			clearscan();
			readindmatrix(b,l1,h1,l2,h2,junks);
			break;		
		case(3):
			printf("Enter diagonal and off-diagonal elements - ");
			inputd(&junkd);
			inputrd(&junkd2);
			IJdmatrix(b,l1,h1,l2,h2,junkd,junkd2);
			break;
		case(4):
			lineardmatrix(b,l1,h1,l2,h2,0);
			break;
		case(5):
			printf("Enter k2 - ");
			inputrd(&junkd);
			lineardmatrix(b,l1,h1,l2,h2,junkd);
			break;
		case(6):
			junkdv=dvector(0,h1-l1);
			printf("Enter vector for matrix construction - \n");
			enterdvector(junkdv,0,h1-l1);
			toeplitzdmatrix(b,l1,h1,l2,h2,junkdv,0);
			free_dvector(junkdv,0,h1-l1);
			break;
		case(7):
			junkdv=dvector(0,h1-l1);
			printf("Enter vector for matrix construction - \n");
			enterdvector(junkdv,0,h1-l1);
			printf("Enter k2 - ");
			inputrd(&junkd);
			toeplitzdmatrix(b,l1,h1,l2,h2,junkdv,junkd);
			free_dvector(junkdv,0,h1-l1);
			break;
		case(8):
			printf("Enter constant - ");
			inputrd(&junkd);
			constantdmatrix(b,l1,h1,l2,h2,junkd);
			break;
		case(9):
			break;
		case(11):	/* Random routines should only be used */
			randomdmatrix(b,l1,h1,l2,h2,1,1.0);	/*with a randomise(seed)*/
			break;			/*elsewhere in program*/ 
		case(12):				/*This is deliberate to avoid */ 
			randomdmatrix(b,l1,h1,l2,h2,2,1.0); /* destruction of other seeds*/
			break;
		case(13):
		case(14):
			printf("Enter upper limit - ");
			inputrd(&junkd);
			randomdmatrix(b,l1,h1,l2,h2,u-12,junkd);
			break;
		default:
			crash("error in enterdmatrix");
			break;
	}
}

double readindmatrix (b,l1,h1,l2,h2,file)
	char	file[50];
	double 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j;
	FILE    *fp;
	double	sumd=0.0;

	fp = fopen( file, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	printf( "reading in matrix from %s\n",file );
	for (i=l1; i<=h1; i++){
		for (j=l2; j<=h2; j++){
			fscanf(fp,"%lf ",&b[i][j]);
			sumd += b[i][j];
		}
	}
	fclose( fp );
	printf( "matrix in\n" );
	return(sumd);
}

void readinlumatrix (b,indx,n,file)
	char	file[50];
	double 	**b;
	int 	n,*indx;
{
	int	i, j;
	FILE    *fp;

	fp = fopen( file, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	printf( "reading in matrix\n" );
	for (i=1; i<=n; i++){
		for (j=1; j<=n; j++){
			fscanf(fp,"%lf ",&b[i][j]);
		}
	}
	for (i=1; i<=n; i++){
		fscanf(fp,"%d ",&indx[i]);
	}
	fclose( fp );
	printf( "lu matrix in\n" );
}

void dmatrixfromimatrix (b,l1,h1,l2,h2,f)
	int	**f;
	double 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j;

	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			b[i][j]=(double)(f[i][j]);
}

void dmatrixfromdmatrix (b,l1,h1,l2,h2,f)
	double	**f;
	double 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j;

	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			b[i][j]=(f[i][j]);
}

void dmatrixfromcmatrix (b,l1,h1,l2,h2,f)
	unsigned char	**f;
	double 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j;

	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			b[i][j]=(double)(f[i][j]);
}

void cmatrixfromdmatrix (c,l1,h1,l2,h2,d)
	unsigned char	**c;
	double 	**d;
	int 	l1,h1,l2,h2;
{
	int	i, j;

	for (i=l1; i<=h1; i++){
		for (j=l2; j<=h2; j++){
			if (d[i][j]>=255.0) c[i][j]=255;
			else if (d[i][j]<=0.0) c[i][j]=0;
			c[i][j]=(unsigned char)(d[i][j]);
		}
	}
}

void redistributedmatrix (b,l1,h1,l2,h2,grain)
	int	grain;
	double 	**b;
	int 	l1,h1,l2,h2;
{
	int	i,j,grainsize,ii,jj;
	double	current;

	if(!grain) printf("Redistribution routine called with grain number = 0\n");
	else{
		grainsize=ipower(2,grain);

		for (i=l1; i<=h1+1-grainsize; i+=grainsize){
			for (j=l2; j<=h2+1-grainsize; j+=grainsize){
				current=0.0;
				for (ii=0; ii<grainsize; ii++)
					for (jj=0; jj<grainsize; jj++)
						current+=b[i+ii][j+jj];
				current/=(double)(grainsize*grainsize);
				for (ii=0; ii<grainsize; ii++)
					for (jj=0; jj<grainsize; jj++)
						b[i+ii][j+jj]=current;
			}
		}
	}
/* note this leaves alone cells round the outer border */ 
}

int readinimatrix (b,l1,h1,l2,h2,file)
	char	file[50];
	int 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j;
	int	sum=0;
	FILE    *fp;

	fp = fopen( file, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	printf( "reading in matrix\n" );
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++){
			fscanf(fp,"%d ",&b[i][j]);
			sum+= b[i][j];
		}
	fclose( fp );
	printf( "matrix in\n" );
	return(sum);
}

int readincmatrix (b,l1,h1,l2,h2,file)
	char	file[50];
	unsigned char 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j, temp, sum=0;
	FILE    *fp;

	fp = fopen( file, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	printf( "reading in matrix\n" );
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++){
			fscanf(fp,"%d ",&temp);
			b[i][j]=(unsigned char)temp;
			sum+=temp;
		}
	fclose( fp );
	printf( "matrix in\n" );
	return(sum);
}

void dividecmatrix (b,l1,h1,l2,h2,g)
	unsigned char 	**b;
	int 	l1,h1,l2,h2,g;
{
	int	i, j;
	unsigned char gg;

	gg=(unsigned char) g;
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			b[i][j]/=gg;

}

void multiplycmatrix (b,l1,h1,l2,h2,g)
	unsigned char 	**b;
	int 	l1,h1,l2,h2,g;
{
	int	i, j;
	unsigned char gg;

	gg=(unsigned char) g;
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			b[i][j]*=gg;

}

void readincbmatrix (b,l1,h1,l2,h2,file)
	char	file[50];
	unsigned char 	**b;
	int 	l1,h1,l2,h2;
{
	int	i, j, temp;
	FILE    *fp;

	fp = fopen( file, "rb" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	printf( "reading in matrix\n" );
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			b[i][j]=getc(fp);
	fclose( fp );
	printf( "matrix in\n" );
}

void randomdmatrix (b,l1,h1,l2,h2,type,scale)
	double 	**b,scale;
	int 	l1,h1,l2,h2,type;
{
	int	i, j;

	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			b[i][j]=l_random(type,scale);
}

void  k2dmatrix(b,l1,h1,l2,h2,option)
	double 	**b;
	int 	l1,h1,l2,h2,option;
{
        int i,j,t;
	double	temp;
         
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
                        b[i][j]= 0.0;
	switch(option){
	case(1):
	case(2):
	case(3):
	case(4):
	case(5):
	case(6):
		for (i=l1+1,j=l2+1; i<=h1&&j<=h2; i++,j++){
          		t=i/2; /* assuming cos 0 , sin 1 , cos 1 ,... = 1,2,3 */
		      	b[i][j] = dpower((double)(t),option);
		}
		b[l1][l2]=1.0;
		break;
	case(7):
	case(8):
	case(9):
	case(10):
		option-=6;
		for (i=l1+1,j=l2+1; i<=h1&&j<=h2; i++,j++){
		      	b[i][j] = dpower(2.0,option*i);
		}
		b[l1][l2]=1.0;
		break;
	case(18):
		for (i=l1,j=l2; i<=h1&&j<=h2; i++,j++){
		      	b[i][j] = 2.0/(1.0+2.0*(double)(i-1));
		}
		break;
	case(28):
		for (i=l1,j=l2,temp=1.0; i<=h1&&j<=h2; i++,j++){
		      	b[i][j] = temp;
			temp*=2.0*(double)(i);
		}
		break;
	default:
		printf("Error in k2dmatrix\n");
		break;
	}
}

void  IJdmatrix(b,l1,h1,l2,h2,ii,jj)
	double 	**b;
	int 	l1,h1,l2,h2;
        double jj,ii; 
{
        int i,j;
         
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
                        b[i][j]= jj;
	for (i=l1,j=l2; i<=h1&&j<=h2; i++,j++)
                b[i][j] = ii;
}

void  constantdmatrix(b,l1,h1,l2,h2,jj)

	double 	**b;
	int 	l1,h1,l2,h2;
        double jj; 
{
        int i,j;
         
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
                        b[i][j]= jj;
}

void  constantimatrix(b,l1,h1,l2,h2,jj)

	int 	**b,jj;
	int 	l1,h1,l2,h2;
{
        int i,j;
         
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
                        b[i][j]= jj;
}

void  constantcmatrix(b,l1,h1,l2,h2,jj)

	unsigned char 	**b,jj;
	int 	l1,h1,l2,h2;
{
        int i,j;
         
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
                        b[i][j]= (unsigned char) jj;
}

void readindmatrix3 (b,l1,h1,l2,h2,l3,h3,file)
	char	file[50];
	double 	***b;
	int 	l1,h1,l2,h2,l3,h3;
{
	int	l, i, j;
	FILE    *fp;

	fp = fopen( file, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	printf( "reading in matrix\n" );
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			for (l=l3; l<=h3; l++)
				fscanf(fp,"%lf ",&b[i][j][l]);
			
	fclose( fp );
	printf( "matrix in\n" );
}

void randomisedmatrix3(b,l1,h1,l2,h2,l3,h3,ranmax)
	double 	***b,ranmax;
	int 	l1,h1,l2,h2,l3,h3;
{
	int	l, i, j;
	double	scale;

	scale	= 2*ranmax;
	printf( "randomising matrix\n" );
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
			for (l=l3; l<=h3; l++)
				b[i][j][l]=(l_random_1()*scale)-ranmax;
	printf( "matrix done\n" );
}

void constructaQa (M,NP,ca,spost)
	int NP;
	double **M;
	double ca,*spost; 
{
	int i,j;
	
	for (i=0;i<=NP-1;i++)
        	for (j=0;j<=NP-1;j++)
        		M[i][j]=spost[i]*spost[j]*(NP + ca - fabs((double)(i-j)));
}
  
void 	constructdmatrix (M,NP,ca)
	int NP;
	double **M;
	double ca; 
{
	int i,j;
		
	for (i=0;i<=NP-1;i++)
        	for (j=0;j<=NP-1;j++)
        		M[i][j]= NP + ca - fabs((double)(i-j));
}
  
void 	lineardmatrix(M,l1,h1,l2,h2,ca) 
	int 	l1,h1,l2,h2;
	double **M;
	double ca; 
{
	int 	i,j,offset;
	double 	n;
	
	n=(double)h1-l1+1;
	offset=l1-l2;
		
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
        		M[i][j]= n + ca - fabs((double)(i-j-offset));
}

void 	toeplitzdmatrix(M,l1,h1,l2,h2,v,ca) 
	int 	l1,h1,l2,h2;
	double 	**M,*v;
	double 	ca; 
{
	int 	i,j,offset;
	double 	n;
	
	offset=l1-l2;
	for (i=l1; i<=h1; i++)
		for (j=l2; j<=h2; j++)
        		M[i][j]=  ca + v[abs(i-j-offset)];
}

/* output */

void printoutfvector(w,n)
	int n;
	float *w;
{
	int i;
	
	printf("Here are %d components\n",n);
	for (i=0;i<=n-1;i++)
		printf("%g ",w[i]);
	newline();
}

void printoutivector(w,n)
	int n;
	int *w;
{
	int i;
	
	printf("Here are %d components\n",n);
	for (i=0;i<=n-1;i++)
		printf("%d ",w[i]);
	newline();
}

void printoutimatrix (M,NP)
	int NP;
	int **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) printf("%d ",M[i][j]);
          	printf("\n");
     	}                   
}

void printoutfmatrix (M,NP)
	int NP;
	float **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) printf("%7.2f",M[i][j]);
          	printf("\n");
     	}                   
}

void printoutdmatrix (m,l1,h1,l2,h2,style)
	int 	l1,h1,l2,h2,style;
	double	**m;
{
	int i,j;
	
	for (i=l1; i<=h1; i++){
		for (j=l2; j<=h2; j++)
        	 	pd(m[i][j],style);
          	printf("\n");
     	}                   
}

void    write_dvector_to(fp,p,lo,hi,newln)
     int        lo,hi,newln;
     double     *p;
     FILE       *fp;
{
  int   i;
  
  for(i=lo;i<=hi;i++){
    fprintf(fp,"%g      ",p[i]);
  }
  if(newln)fnewline;
}

void writelumatrix (m,n,indx,file)
	int 	n,*indx;
	char	file[50];
	double	**m;
{
	int i,j;
	FILE    *fp;

	fp = fopen( file, "w" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);
	
	for (i=1; i<=n; i++){
		for (j=1; j<=n; j++){
        	 	fprintf(fp,"%9g ",m[i][j]);
		}
		fnewline;
     	}     
	for (i=1; i<=n; i++)
        	 fprintf(fp,"%d ",indx[i]);
	fnewline;
	fclose(fp);              
}

void writedmatrix (m,l1,h1,l2,h2,file)
	int 	l1,h1,l2,h2;
	char	file[50];
	double	**m;
{
	int i,j;
	FILE    *fp;

	fp = fopen( file, "w" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);
	
	for (i=l1; i<=h1; i++){
		for (j=l2; j<=h2; j++){
        	 	fprintf(fp,"%9g ",m[i][j]);
		}
		fnewline;
     	}     
	fclose(fp);              
}

void pr_cov_matrix (m,l1,h1,l2,h2,style)
	int 	l1,h1,l2,h2,style;
	double	**m;
{
	int i,j;
	
	for (i=l1; i<=h1; i++){
		for (j=l2; j<=i; j++)
			if(i==j)pd(m[i][j],style);
        	 	else pd(m[i][j]/sqrt(m[i][i]*m[j][j]),style);
          	printf("\n");
     	}                   
}

void displaydvector(w,l,n)
	int l,n;
	double *w;
{
	int i;
	
	for (i=l;i<=n;i++)
		printf("%5.2f ",w[i]);
}

void dispdvector(w,l,n)
	int l,n;
	double *w;
{
	int i;
	
	for (i=l;i<=n;i++)
		printf("%1.0f ",w[i]);
}

void pd(w,p) 	/* prints a single double with a specified number of digits */ 
	double 	w;
	int 	p;
{
	switch(p){
		case(0):		/* Don't print */
			break;
		case(-1):		/* Standard format */
			printf("%g ",w);
			break;
		case(1):
			printf("%1.0f ",w);
			break;
		case(100):
			printf("%1.0f ",w*10);
			break;
		case(11):
			if (w==1.0)printf("%1.0f ",w);
			else printf("  ");
			break;
		case(10): /* 0/1 <- -1/1 */
			printf("%1.0f ",(double)(w+1.0)*0.5);
			break;
		case(2):
			printf("%2.0f ",w);
			break;
		case(29):
			printf("%2f ",w);
			break;
		case(21):
			printf("%2.1f ",w);
			break;
		case(20):
			printf("%2.0f ",w);
			break;
		case(200):
			printf("%2.0f",w*100);
			break;
		case(3):
			printf("%3.1f ",w);
			break;
		case(39):
			printf("%3f ",w);
			break;
		case(30):
			printf("%3.0f ",w);
			break;
		case(300):
			printf("%3.0f ",w*1000);
			break;
		case(31):
			printf("%3.1f ",w);
			break;
		case(32):
			printf("%3.2f ",w);
			break;
		case(4):
			printf("%4.1f ",w);
			break;
		case(49):
			printf("%4f ",w);
			break;
		case(40):
			printf("%4.0f ",w);
			break;
		case(400):
			printf("%4.0f ",w*10000);
			break;
		case(41):
			printf("%4.1f ",w);
			break;
		case(43):
			printf("%4.3f ",w);
			break;
		case(42):
			printf("%4.2f ",w);
			break;
		case(52):
			printf("%5.2f",w);
			break;
		case(54):
			printf("%5.4f ",w);
			break;
		case(50): 
			printf("%5.0f ",w);
			break;
		case(500): /* for probabilities */
			printf("%5.0f ",w*100000);
			break;
		case(60): 
			printf("%6.0f ",w);
			break;
		case(62):
			printf("%6.2f ",w);
			break;
		case(72):
			printf("%7.2f ",w);
			break;
		case(76):
			printf("%7.6f ",w);
			break;
		case(5):
			printf("%5g ",w);
			break;
		case(6):
			printf("%6g ",w);
			break;
		case(600):
			printf("%6.0f ",w*1000000);
			break;
		case(7):
			printf("%7g ",w);
			break;
		case(700):
			printf("%7.0f ",w*10000000);
			break;
		default:
			printf("Error in pd rule \n");
			break;
	}
}

void pdv(w,m,n,p)	/* prints dvector without newline, with specified number of digits */
	double	*w;
	int m,n,p;
{
	int i;
	for(i=m;i<=n;i++)
		pd(w[i],p);
}

void piv(w,m,n,p)	/* prints dvector without newline, with specified number of digits */
	int	*w;
	int m,n,p;
{
	int i;
	for(i=m;i<=n;i++)
		pi(w[i],p);
}

void 	pi(w,p) 
	int 	w,p;
{
	switch(p){
		case(0):
			printf("%d ",w);
			break;
		case(1):
			printf("%1d ",w);
			break;
		case(11):
			if (w==1)printf("%1d ",w);
			else printf("  ");
			break;
		case(10): /* 0/1 <- -1/1 */
			printf("%1d ",(double)(w+1.0)/2);
			break;
		case(2):
			printf("%2d ",w);
			break;
		case(200):
			if (w==0) printf("   ");
			else printf("%2d ",w);
			break;
		case(3):
			printf("%3d ",w);
			break;
		case(4):
			printf("%4d ",w);
			break;
		case(5):
			printf("%5d ",w);
			break;
		case(6):
			printf("%6d ",w);
			break;
		case(7):
			printf("%7d ",w);
			break;
		default:
			printf("Error in pi rule \n");
			break;
	}
}
	void debug(n)
	int n;
{
	printf("debug %d\n",n);
}

void 	debugf(n)
	float n;
{
	printf("debug %g\n",n);
}

void 	debugd(n)
	double n;
{
	printf("debug %g\n",n);
}

void newline()
{
	printf("\n");
}
 
void space(n)
	int n;
{
	for(;n>0;printf(" "),n--);
}

/* vectors */
 
void gaussianfvector(w,l,n,s)
	int 	l,n;
	float 	*w,s; /* s is the SD */
{
	int 	i;
	
	for (i=0;i<=n-l;i++)
		w[i+l]=(float)exp((double)-0.5*i*i/(s*s));
}
 
void 	gaussiandvector(w,n,type,s)
	int 	n,type;
	double 	*w,s; /* s is the SD */
{
	int 	i;
	double mid;
	
	switch(type){
		case(1):
			for (i=0;i<=n-1;i++)
				w[i]=(double)exp((double)-0.5*i*i/(s*s));
			break;
		case(2):
			mid=(double)(n-1)/2;
			for (i=0;i<=n-1;i++)
				w[i]=(double)exp(-0.5*((double)i-mid)*((double)i-mid)/(s*s));
			break;
		default:
			crash("error in gaussiandvector");
			break;
	}
}
 
void readinfvector(w,n)
	int 	n;
	float 	*w;
{
	int 	i;
	
	printf("Please enter %d components \n",n);
	for (i=0;i<=n-1;i++)
		scanf("%f",&w[i]);
	clearscan();
}

void readinivector(w,n)
	int n;
	int *w;
{
	int i;
	
	printf("Please enter %d components \n",n);
	for (i=0;i<=n-1;i++)
		scanf("%d",&w[i]);
}

void enterdvector(w,l,h)
	int l,h;
	double *w; /* so w is  w[l] .. w[h] */
{
	int 	i,u,n;
	double junkd;
	double junkd2;
	char junks[50];
	n=h-l+1;
	w+=l; /* so w is now w[0] .. w[n-1] */
	printf( "please choose vector\n" );
	printf( "1 	hand-typed\n" );	
	printf( "a 	random 0 <-> 1\n" );
	printf( "b 	random -1 <-> 1\n" );
	printf( "c 	random one-sided (0-max)\n" );
	printf( "d 	random symmetrical\n" );
	printf( "e 	random (min-max)\n" );
	printf( "s 	slope (a-b)\n" );
	printf( "2 	read in from file\n" );
	printf( "3 	one-sided gaussian\n" );
	printf( "4 	symmetrical gaussian\n" );
	printf( "5 	n = 1,1,1,1 \n" );
	printf( "6 	n^ = 1/sqr(N)(1,1,1,1) \n" );	
	printf( "7 	constant * n \n" );
	printf( "8 	0,0,0,0 \n" );
	printf( "Return	hand-typed \n" );
	u=respond();
	switch(u){
		case(1):
			typeindvector(w,n);	
			break;	 
		case(11):	/* Random routines should only be used */
			randomdvector(w,n,1,1.0);	/*with a randomise(seed)*/
			break;			/*elsewhere in program*/ 
		case(12):				/*This is deliberate to avoid */ 
			randomdvector(w,n,2,1.0); /* destruction of other seeds*/
			break;
		case(13):
		case(14):
			printf("Enter upper limit - ");
			inputrd(&junkd);
			randomdvector(w,n,u-12,junkd);
			break;
		case(15):
			printf("Enter lower limit - ");
			inputrd(&junkd);
			printf("Enter upper limit - ");
			inputrd(&junkd2);
			randomdvector(w,n,1,junkd2-junkd);
			addtodvector(w,n,junkd); 
			break;
		case(29):
			printf("Enter left value - ");
			inputrd(&junkd);
			printf("Enter right value (this value will not quite be used) - ");
			inputrd(&junkd2);
			dvectortoslope(w,n,junkd,junkd2);
			break;
		case(2):
			printf("enter file name - ");
			scanf("%s", junks);
			clearscan();
			readindvector(w,n,junks);
			break;
		case(3):
		case(4):
			printf("enter size of gaussian - ");
			inputrd(&junkd);
			gaussiandvector(w,n,u-2,junkd);
			break;
		case(5):
			setdvectortoconst(w,n,1.0);
			break;
		case(6):
			setdvectortoconst(w,n,1/sqrt((double)n));
			break;
		case(7):
			printf("enter constant - ");
			inputrd(&junkd);
			setdvectortoconst(w,n,junkd);
			break;
		case(8):
			setdvectortoconst(w,n,0.0);
			break;
		case(9):
			break;
		default:
			typeindvector(w,n);	
			break;
	}
}

void readindvector(w,n,file)
	int n;
	double *w;
	char	file[50];
{
	int i;
	FILE    *fp;
	
	fp = fopen( file, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	for (i=0;i<=n-1;i++)
		fscanf(fp,"%lf ",&w[i]);
	fclose( fp );
}

double 	*readindvectorandsize(min,max,file)
	int 	*min,*max;
	char	file[50];
{
	int i;
	FILE    *fp;
	double 	*w;
	
	fp = fopen( file, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	fscanf(fp,"%d ",min);
	fscanf(fp,"%d ",max);
	w=dvector(min[0],max[0]);
	for (i=min[0];i<=max[0];i++)
		fscanf(fp,"%lf ",&w[i]);
	fclose( fp );
	return(w);
}

void 	writedvectorandsize(w,min,max,file)
	int 	min,max;
	char	file[50];
	double 	*w;
{
	int i;
	FILE    *fp;
	
	fp = fopen( file, "w" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	fprintf(fp,"%d ",min);
	fprintf(fp,"%d ",max);
	for (i=min;i<=max;i++)
		fprintf(fp,"%g ",w[i]);
	fclose( fp );
}

void 	writedvectorandsize_n(w,min,max,file)
	int 	min,max;
	char	file[50];
	double 	*w;
{
	int i;
	FILE    *fp;
	
	fp = fopen( file, "w" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

/*	fprintf(fp,"%d ",min);
	fprintf(fp,"%d ",max); */
	for (i=min;i<=max;i++)
		fprintf(fp,"%g\n",w[i]);
	fclose( fp );
}

void 	writedvectorandsize_conditional(w,con,thresh,min,max,number,file)
	int 	min,max;
	char	file[50];
	double 	*w,*con,thresh;
{
	int i;
	FILE    *fp;
	
	fp = fopen( file, "w" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	fprintf(fp,"%d ",min);
	fprintf(fp,"%d ",number);
	for (i=min;i<=max;i++)
		if(con[i]>thresh){
			fprintf(fp,"%g ",w[i]);
			number--;
		}
	fclose( fp );
	if(number!=0)printf("This number should be zero: %d; it is different, so the file %s does not contain the right number of components\n",number,file); 
}

void 	writedvector(w,n,file)
	int 	n;
	char	file[50];
	double 	*w;
{
	int i;
	FILE    *fp;
	
	fp = fopen( file, "w" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", file ), exit(0);

	for (i=0;i<=n-1;i++)
		fprintf(fp,"%g ",w[i]);
	fclose( fp );
}

void typeindvector(w,n)
	int n;
	double *w;
{
	int i;
	
	printf("Please enter %d components \n",n);
	for (i=0;i<=n-1;i++)
		scanf("%lf",&w[i]);
	clearscan();
}

void setdvectortoconst(w,n,cons1)
	int n;
	double *w;
	double cons1;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		w[i]=cons1;
}

void setivectortocons1(w,n,cons1)
	int n;
	int *w;
	int cons1;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		w[i]=cons1;
}

void dvectorfromdvector(w,n,w2) /* copy NB 0 offset */
	int n;
	double *w,*w2;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		w[i]=w2[i];
}

void copydvector(w2,n,w) /* copy */
	int n;
	double *w,*w2;
{
	int i;
	
	for (i=1;i<=n;i++)
		w[i]=w2[i];
}

void dvectortoslope(w,n,first,last) /* this sets a vector to 
	first,first+bit,...last-bit. (last)  NB last is not actually used.  */ 
	int n;
	double *w;
	double first,last;
{
	int i;
	double bit;

	bit = (last-first)/(double)(n);
	for (i=0;i<=n-1;i++)
		w[i]= first+((double)(i) * bit); 
}

void addtodvector(w,n,cons1)
	int n;
	double *w;
	double cons1;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		w[i]+=cons1;
}

void multiplydvector(w,n,cons1)
	int n;
	double *w;
	double cons1;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		w[i]*=cons1;
}

void randomdvector(w,n,type,scale)
	int 	n,type;
	double *w,scale;
{
	int i;
	for (i=0;i<=n-1; i++)
		w[i]=l_random(type,scale);
}


void printoutdvector(w,l1,h1,style)
	int 	l1,h1,style;
	double 	*w;
{
	int i;
	
	for (i=l1; i<=h1; i++)
		pd(w[i],style);
	newline();
}

 

void print2Ddvector(w,n,m)
	int n,m;
	double *w;
{
	int i,j;
	
	for (i=0;i<=n-1;i+=m){
		for (j=i;j<=i+m-1;j++)
			printf("%6.2f",w[j]);
		newline();
	}
}

/* vector operations */

float fdot(a,b,n)
	float *a,*b;
	int n;
{
	int j;
	float sum=0.0;
	for (j=0;j<=n-1;j++)
		sum += a[j] * b[j];
	return (sum);
}

double ddot(a,b,n)	/* NB 0...n-1 */
	double *a,*b;
	int n;
{
	int j;
	double sum=0.0;

	for (j=0;j<=n-1;j++)
		sum += a[j] * b[j];
	return (sum);
}

double dmatrixsum (M,NP,spost)
	int NP;
	double **M;
	double *spost; 
{
	int i,j;
	double c=0;
	
	for (i=0;i<=NP-1;i++)
        	for (j=0;j<=NP-1;j++)
        		c+=M[i][j]*spost[i]*spost[j];
	return(c);
}

double dmatrixsum2 (M,NP)
	int NP;
	double **M;
{
	int i,j;
	double c=0;
	
	for (i=0;i<=NP-1;i++)
        	for (j=0;j<=NP-1;j++)
        		c+=M[i][j];
	return(c);
}

double	diagproduct(hessin,lo,hi)
	double	**hessin;
	int	lo,hi;
{
	double dtemp=1.0;

	for(;lo<=hi;lo++)
		dtemp*=hessin[lo][lo];
	return(dtemp);
}

void leftimatrixmultiply (y,M,x,l1,h1,l2,h2)
	int  **M,*x,*y;
	int 	l1,h1,l2,h2;
{
	int i,j;
	
	for (i=l1; i<=h1; i++){
		y[i]=0;
		for (j=l2; j<=h2; j++)
        		y[i]+=M[j][i]*x[j];
	}
}

void rightimatrixmultiply (y,M,x,l1,h1,l2,h2)
	int  **M,*x,*y;
	int 	l1,h1,l2,h2;
{
	int i,j;
	
	for (i=l1; i<=h1; i++){
		y[i]=0;
		for (j=l2; j<=h2; j++)
        		y[i]+=M[i][j]*x[j];
	}
}

void leftdmatrixmultiply (y,M,x,l1,h1,l2,h2)
	double  **M,*x,*y;
	int 	l1,h1,l2,h2;
{
	int i,j;
	
	for (i=l1; i<=h1; i++){
		y[i]=0;
		for (j=l2; j<=h2; j++)
        		y[i]+=M[j][i]*x[j];
	}
}

void rightdmatrixmultiply (y,M,x,l1,h1,l2,h2)
	double  **M,*x,*y;
	int 	l1,h1,l2,h2;
{
	int i,j;
	
	for (i=l1; i<=h1; i++){
		y[i]=0;
		for (j=l2; j<=h2; j++)
        		y[i]+=M[i][j]*x[j];
	}
}

void	reorderd(ra,a,b,type)
	int	a,b;
	double	*ra;
	int	type;
{
	int l,j,ir,i,n;
	double rra;

	n = b - a + 1;
	ra += a - 1;
	l=(n >> 1)+1;
	ir=n;
	for (;;) {
		if (l > 1)
			rra=ra[--l];
		else {
			rra=ra[ir];
			ra[ir]=ra[1];
			if (--ir == 1) {
				ra[1]=rra;
				return;
			}
		}
		i=l;
		j=l << 1;
		while (j <= ir) {
			switch(type){
				case(-1):
					if (j < ir && ra[j] > ra[j+1]) ++j;
					if (rra > ra[j]) {
						ra[i]=ra[j];
						j += (i=j);
					}
					else j=ir+1;
					break;
				case(1): /* ascending */ 
				default:
					if (j < ir && ra[j] < ra[j+1]) ++j;
					if (rra < ra[j]) {
						ra[i]=ra[j];
						j += (i=j);
					}
					else j=ir+1;
					break;
			}
		}
		ra[i]=rra;
	}


}
  
/* input */

void inputf(pointer)
	float *pointer;
{
	int junk;
	scanf("%f",pointer);
	junk=getchar();
}
void inputd(pointer)
	double *pointer;
{
	int junk;
	scanf("%lf",pointer);
	junk=getchar();
}
void inputi(pointer)
	int *pointer;
{
	int junk;
	scanf("%d",pointer);
	junk=getchar();
}

void inputrf(pointer)
	float *pointer;
{
	int junk;
	scanf("%f",pointer);
	do{}while((junk=getchar())!=10);
}
void inputrd(pointer)
	double *pointer;
{
	int junk;
	scanf("%lf",pointer);
	do{}while((junk=getchar())!=10);
}
void inputri(pointer)
	int *pointer;
{
	int junk;
	scanf("%d",pointer);
	do{}while((junk=getchar())!=10);
}
void clearscan()
{
	int junk;
	do{}while((junk=getchar())!=10);
}

/* maths */

int	int_round(x)
	double	x;
{
	if(x>0.0)	return((int)(x+0.5));
	else		return((int)(x-0.5));
}

double	double_round(x)
	double	x;
{
	return((double)(int_round(x)));
}

double	logfactorial(j)
	int	j;
{
	int	f;
	double	d=0.0;

	for(f=2;f<=j;f++)	d+= log((double)(f));
	return	d;
}

double	factorial(j)
	int	j;
{
	int	f;
	double	d=1.0;

	for(f=2;f<=j;f++)	d*= ((double)(f));
	return	d;
}

int	intin(a,min,max)
	int	a,min,max;
{
	if((a>=min) || (a<=max)) return(1);
	else return(0);
}

int	signdifff(a,b)
	float a,b;
{
	if (sgnf(a)!=sgnf(b)) return (1);
	else return (0);
}

int	sgnf(a)
	float a;
{
	if (a>0) return (1);
	else return (-1);
}

int	ipower(a,b)
	int	a,b;
{
	int	i=1;

	for(;b>0;b--)
		i*=a;
	return(i);
}

double	dpower(a,b)
	int	b;
	double	a;
{
	double	i=1.0;

	if(b>0)
		for(;b>0;b--)
			i*=a;
	else if(b<0)
		for(;b<0;b++)
			i/=a;
	return(i);
}

double	ddpower(a,b)
	double	a,b;
{
	return( exp(b*log(a)) );
}

int	equald(a,b,fraction)
	double	a,b,fraction;
{
	if( (fabs(a-b)/(fabs(a)+fabs(b))) > fraction ) return(0);
	else return(1);
}

/* crash */

void crash(string)
	char    *string;
{
    	fprintf( stderr, "%s\n", string);
    	fprintf( stderr, "routine aborted\n");
    	exit(-1);
}

void bleep(string)
	char    *string;
{
    	fprintf( stderr, "%s\n", string);
    	fprintf( stderr, "routine continues\n");
}

/* file handling routines */

void read_qspec(qspec,n,m)
	int *n,*m;
	char	qspec[50];
{
	FILE    *fp;

	fp = fopen( qspec, "r" );
	if( !fp )   fprintf( stderr, "No such file: %s\n", qspec ), exit(0);
   
	fscanf( fp, "%d", n );
	fscanf( fp, "%d", m );
	printf( "Have Read in qspec\n" );
	
	fclose( fp );
}

void generate_q(outputq,q,n,m)
	char	outputq[50];
	double **q;
	int n,m;
{
	int		l, i, j, k;
	FILE    *fp;
	
	fp = fopen( outputq, "w" );

	printf( "Generating Q\n" );
	for (i=0; i<=m-1; i++)
		for (fnewline,j=0; j<=m-1; j++)
			for (fnewline,k=0; k<=m-1; k++)
				for (fnewline,l=0; l<=m-1; l++)
					fprintf(fp,"%.10f ",q[m * i + j][m * k + l]=qfunction2(abs(i-k),abs(j-l),m)); 
	fnewline;
	fclose( fp );
	printf( "q done\n" );
}

/* silly functions */

double qfunction1(i,j,m)
	int	i,j,m;
{
	return ((m-i)*(m-j));
}

double qfunction2(i,j,m)
	int	i,j,m;
{
	return (exp(-((double)(i * i)+(double)(j * j))/((double)m * m / 2)));
}
double qfunction3(i,j,m)
	int	i,j,m;
{
	return ((double) m- sqrt((double)(i * i)+(double)(j * j) ) );
}
	
void add_ca_and_printoutdmatrix (M,NP,ca)
	int NP;
	double ca;
	double **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) printf("%7.2f",M[i][j]+=ca);
          	printf("\n");
     	}                   
}

	
void add_ca_todmatrix (M,NP,ca)
	int NP;
	double ca;
	double **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++)
        	for (j=0;j<=NP-1;j++) 
			M[i][j]+=ca;
}

#undef TINY

