#include "r.h"
#include "mynr.h"
#include "../inter/bigint.h" /* NB to make inter work, should change this back to 
					inter.h maybe */
double	f1dim(x,icontrol,dcontrol,k)
	int	*icontrol,k;	 
	double	x,*dcontrol;
{
	int	family,member;
	double	dmember,location,dhouse,delta,dhalf;
	int 	verbose=1,half,odd;

	family 	= icontrol[FAMNUMBER];
	switch(family){
	case(1):case(3):case(6):case(7):
		member	= k-1; 
		break;
	case(5):case(4):case(2):default:
		member	= k; 
		break;
	}
	dmember = (double)(member);
	
	if(verbose==2) printf("family %d, member %d\n",family, member);

	if(member==0) return(1.0);
	else switch(family){
	case(1):	/* polynomials */
		return( dpower(x,member) );
		break;
	case(3):	/* fourier set,mixed  */
		half	= (member+1)/2;
		odd	= member%2;
		dhalf	= (double)(half);
		if(odd) return( sin(dhalf*dparam[OMEGA]*x+ dparam[THETA]) );
		else return( cos(dhalf*dparam[OMEGA]*x+ dparam[THETA]) );
		break;
	case(6):	/* fourier set,cos  */
		return( cos(dmember*dparam[OMEGA]*x+ dparam[THETA]) );
		break;
	case(7):	/* fourier set,sin  */
		return( sin(dmember*dparam[OMEGA]*x+ dparam[THETA]) );
		break;
	case(5):	/* location set -- 1/1+x^2 */
	case(4):	/* location set -- triangle */
	case(2):	/* location set -- gaussian */
		location = dmember*dparam[LOCATIONIN] + dparam[ZEROLOC];
		if((delta=fabs(location-x))>dparam[HOUSEEX])	return(0.0);
		else	
			return( location_function2(family,delta/dparam[RADIUS]));
		break;
	default:
		printf("Invalid family number, func(%d,%g)\n",i,x);
		crash("Invalid family number");
		break;
	}
}

double fkdim(ndimensions,xvector,dparam,iparam,n)
	int	ndimensions,**iparam,*n;
	double	*xvector;
{
	switch(iparam[1][FUNCCLASS]){
	case(RBFCAUCHY):
	default:
		for(dist=0.0,l=1;l<=ndimensions;l++){
			dtemp1=(xvector[l]-dparam[l][XZERO])/dparam[l][XRADIUS]-(double)(n[l]);
			dist+= dtemp1*dtemp1;
		}
		answer = 1.0/(1.0+dist);
		break;
	}
	return(answer);		
}

/* model of what the recursive routines do */

/* for separable functions of x1,x2,x3 */
/* k=1;
for(n1=1;n1<=KK;n1++){
	sofar1=function(1,n1,x1);
	for(n2=1;n2<=KK;n2++){
		sofar2=sofar1*function(2,n2,x2);
		for(n3=1;n3<=KK;n3++){
			sofar3=sofar2*function(3,n3,x3);
			phi[k]=sofar3;
			k++;
		}
	}
} */

/* for non-separable functions of x1,x2,x3 *//*
k=1;
for(n1=1;n1<=KK;n1++){
	for(n2=1;n2<=KK;n2++){
		for(n3=1;n3<=KK;n3++){
			phi[k]=function(x1,x2,x3);
			k++;
		}
	}
}*/

separable_function(type,phiv,phim,k,inv)
		/* type =1 / 2, phiv = vector to put answers in, phim = matrix to put answers in phim[.][k],  inv = input vector */
	int	type,k;
	double	*phiv,**phim,*inv;
{
	int i,element;

	/* set up function values */
	for(i=1;i<=INPUTN;i++)
		(FUNCTIONVALUES[i],inv[i],);
	element=0;
	recursive_product(1,INPUTN,type,phiv,phim,k,&element,1.0);
	if(VERBOSE)printf("Recursive routine generated %d values\n",element);
}

recursive_product(level,totallevel,type,phiv,phim,kkk,xvector,dparam,phi,kpointer,iparam,sofar)
	int	level,totallevel,*kpointer,**iparam,kkk;
	double	sofar,*xvector,**dparam,*phi;
{
	double	mysofar;
	int	k;
	
	for(k=1;k<=KKS[level];k++){
		mysofar = sofar * FUNCTIONVALUES[level][k];
		if(level==totallevel){
			if(type==1)
				phiv[kpointer[0]]=mysofar;
			else	phim[kpointer[0]][kkk]=mysofar;
			kpointer[0]++;
		}
		else
			recursive_product(level+1,totallevel,mysofar);
	}
}


nonseparable_function_recursive(level,totallevel,xvector,dparam,phi,kpointer,iparam,n)
	int	level,totallevel,*kpointer,**iparam;
	double	*xvector,**dparam,*phi;
{
	double	mysofar;
	int	k;
	
	for(n[level]=1;n[level]<=iparam[level][1];n[level]++){
		if(level==totallevel){
			if(type==1)
				phiv[kpointer[0]]=fkdim(totallevel,xvector,dparam,iparam,n);
			else	phim[kpointer[0]][kkk]=fkdim(totallevel,xvector,dparam,iparam,n);
			kpointer[0]++;
		}
		else
			nonseparable_function_recursive(level+1,totallevel,xvector,dparam,phi,kpointer,iparam);

	}
}

/*
f1dim(x,icontrol,dcontrol,k)

fkdim(ndimensions,xvector,dparam,iparam,n)
	switch(iparam[1][FUNCCLASS]){
	case(RBFCAUCHY):
	default:
		for(dist=0.0,l=1;l<=ndimensions;l++){
			dtemp1=(xvector[l]-dparam[l][XZERO])/dparam[l][XRADIUS];
			dist+= dtemp1*dtemp1;
		}
		answer = 1.0/(1.0+dist);
		break;
	}
	return(answer);		

*/
subfunction(j,x)
{
}

makefamily(family,x,iparam,dparam)
{
	int	j;

	switch(iparam[C_FAMNUM]){
	case(2): /* h polynomials */
		break;
	case(4): /* gaussian rbfs */
	case(6): /* mixed fourier */
	case(8): /* triangle */
	case(10): /* cauchy */
		for(j=1;j<=KKS[i];j++)
			family[j]=subfunction(j,x,iparam,dparam);
		break;
	default:
		crash("Family number %d problem \n",iparam[C_FAMNUM]);
		break;
	}
}

int	groupgeneratable(famnum);
{
	switch(famnum){
	case(0):case(1):case(2):
		return(1);
		break;
	case(4):case(5):case(6):default:
		return(0);
		break;
	}
}


