/*
/*  double	**Read_rf( filename, Xsize, Ysize, header, red, green, blue )
/*  unsigned char	**Read_rf_uc( filename, Xsize, Ysize, header, red, green, blue )
/*  void	Write_rf( filename, Image, Xsize, Ysize, header, red, green, blue )
/*  void	Initialize_rf_Header( header, red, green, blue, Xsize, Ysize, Depth, Color );
/*  void	Scale_Image( Image, Xsize, Ysize, min_value, max_value )
/*
/*  The first two routines read and writes rasterfiles, respectively.
/*
/*  `Initialize_rf_Header' puts appropriate values in header, red, green, and blue.
/*  This is useful when an image is created and not read from a file.
/*
/*  `Scale_Images' scales a double matrix so that all values lie between
/*  min_value and max_value, as specified.
/*
/*  Rasterfiles are stored as one character per pixel, while the program
/*  works with one double per pixel.  The conversion is done in the I/O
/*  routines.
/*
*/

/*************************************************
**************   includes, defines   *************
**************************************************/

#define		RW_RASFILE_IS_DEFINED		1

#include "r.h"
#include	<rasterfile.h>
#include	</home/mackoj.h> /* added by me for makefile purposes */

/* #ifndef		ARRAY_IS_DEFINED		CUT BY ME. 
/* #include	</home/mackarray.c>
/* #endif
/* 
/* #ifndef		SUNDRY_GOODIES_IS_DEFINED
/* #include	</home/macksundry_goodies.c>
/* #endif				
/*  #include	<rasterfile.h>   
*/


/*************************************************
**************         index         *************
**************************************************/


/*************************************************
**************     subroutines       *************
**************************************************/



/********       Read_rf        **********/

double	**Read_rf( filename, Xsize, Ysize, header, red, green, blue )
	int	*Xsize, *Ysize;
	char	*filename, *red, *green, *blue;
	struct	rasterfile	*header;
{
	int	i, j;
	double	**Image;
	char	*cp;
	FILE	*fpin;

	if (!can_file_be_opened( filename ) )   {
		fprintf( stderr, "*** ERROR: can't open file ***\n\n" );
		return ((double **) NULL);
	}
	fpin  = fopen( filename, "r" );
	cp = (char *) header;     /** read header **/
	for( i=0; i<sizeof(*header); i++, cp++ )
		cp[0] = getc(fpin);
	(*Xsize) = (*header).ras_width;
	(*Ysize) = (*header).ras_height;
	for( i=0; i<256; i++ ) { red[i] = getc(fpin);}
	for( i=0; i<256; i++ ) { green[i] = getc(fpin);}
	for( i=0; i<256; i++ ) { blue[i] = getc(fpin);}
	Image = (double **) make_array( 2, sizeof(double), *Xsize, *Ysize );
	for( j=0; j<*Ysize; j++ )
		for( i=0; i<*Xsize; i++ )
			Image[i][j] = (double) getc(fpin);
	fclose( fpin );
	return( Image );
}

/********       Read_rf_i      **********/

unsigned char	**Read_rf_uc( filename, Xsize, Ysize, header, red, green, blue )
	int	*Xsize, *Ysize;
	char	*filename, *red, *green, *blue;
	struct	rasterfile	header;
{
	int	i, j;
	unsigned char	**Image;
	char	*cp;
	FILE	*fpin;

	fpin  = fopen( filename, "r" );
	cp = (char *) &header;     /** read header **/
	for( i=0; i<sizeof(header); i++, cp++ )
		cp[0] = getc(fpin);
	(*Xsize) = header.ras_width;
	(*Ysize) = header.ras_height;
	for( i=0; i<256; i++ )     red[i] = getc(fpin);
	for( i=0; i<256; i++ )   green[i] = getc(fpin);
	for( i=0; i<256; i++ )    blue[i] = getc(fpin);
	Image = (unsigned char **) make_array( 2, sizeof(unsigned char),
		*Xsize, *Ysize );
	for( j=0; j<*Ysize; j++ )
		for( i=0; i<*Xsize; i++ )
			Image[i][j] = (unsigned char) getc(fpin);
	fclose( fpin );
	return( Image );
}

/********      Write_rf       **********/

void	Write_rf( filename, Image, Xsize, Ysize, header, red, green, blue )
	int	Xsize, Ysize;
	char	*filename, *red, *green, *blue;
	double	**Image;
	struct	rasterfile	*header;
{
	int	i, j;
	char	*cp;
	FILE	*fpout;

	if (strcmp( filename, "stdout" ))
		fpout = fopen( filename, "w" );
	else
		fpout = stdout;
	cp = (char *) header;
	for( i=0; i<sizeof(*header); i++, cp++ )
		putc( *cp, fpout );
	for( i=0; i<256; i++ )     putc(   red[i], fpout );
	for( i=0; i<256; i++ )     putc( green[i], fpout );
	for( i=0; i<256; i++ )     putc(  blue[i], fpout );
	for( j=0; j<Ysize; j++ )   {
		for( i=0; i<Xsize; i++ )   {
			putc( (char) Image[i][j], fpout );
		}
	}
	fclose( fpout );
}

void	Write_rf_uc( filename, Image, Xsize, Ysize, header, red, green, blue )
	int	Xsize, Ysize;
	char	*filename, *red, *green, *blue;
	unsigned char	**Image;
	struct	rasterfile	*header;
{
	int	i, j;
	char	*cp;
	FILE	*fpout;

	if (strcmp( filename, "stdout" ))
		fpout = fopen( filename, "w" );
	else
		fpout = stdout;
	cp = (char *) header;
	for( i=0; i<sizeof(*header); i++, cp++ )
		putc( *cp, fpout );
	for( i=0; i<256; i++ )     putc(   red[i], fpout );
	for( i=0; i<256; i++ )     putc( green[i], fpout );
	for( i=0; i<256; i++ )     putc(  blue[i], fpout );
	for( j=0; j<Ysize; j++ )   {
		for( i=0; i<Xsize; i++ )   {
			putc( (char) Image[i][j], fpout );
		}
	}
	fclose( fpout );
}

/**********   Initialize_rf_Header   ***********/

/* #define		DEPTH_1		1		*/
/* #define		DEPTH_8		8		*/
/* #define		BW		RMT_NONE		*/
/* #define		COLOR		RMT_EQUAL_RGB		*/

void	Initialize_rf_Header( header, red, green, blue, Xsize, Ysize, Depth, Maptype )
	int	Xsize, Ysize, Depth, Maptype;
	char	*red, *green, *blue;
	struct	rasterfile	*header;
{
	int	i;

	(*header).ras_magic	= 0x59a66a95;
	(*header).ras_width	= Xsize;
	(*header).ras_height	= Ysize;
	(*header).ras_depth	= Depth;
	(*header).ras_length	= Xsize * Ysize * Depth;
	(*header).ras_type	= RT_STANDARD;
	(*header).ras_maptype	= Maptype;
	(*header).ras_maplength	= 3 * 256;
	for (i=0; i<256; i++)
		red[i] = green[i] = blue[i] = (char) i;
}

void	colour(red, green, blue, option )
	char	*red, *green, *blue;
	int option;
{
	int	i,j,k=0,*r,*b,*g,*r2,*b2,*g2;
	double	amplitude,period;
/* 	NOTES: my favourites are 7, 9, 167 */ 
/* 	7 has good relative sizes of bands. 
	9 has rich colours
	167 is my best intensity-hue arrangement */ 
/* 	to put all the gain from the midpoint up, use 72 73 74 or one of the 9000  numbers */

#define	RED	red[i] = (char) 255; green[i] = (char) 127; blue[i] = (char) 127;
#define	PURERED	red[i] = (char) 255; green[i] = (char) 0; blue[i] = (char) 0;
#define	DARKRED	red[i] = (char) 200; green[i] = (char) 0; blue[i] = (char) 0;
#define	GREY	red[i] = (char) 127; green[i] = (char) 127; blue[i] = (char) 127;
#define	WHITE	red[i] = (char) 255; green[i] = (char) 255; blue[i] = (char) 255;
#define	BLACK	red[i] = (char) 0; green[i] = (char) 0; blue[i] = (char) 0;
#define	GREEN	red[i] = (char) 127; green[i] = (char) 255; blue[i] = (char) 127;
#define	PUREGREEN	red[i] = (char) 0; green[i] = (char) 255; blue[i] = (char) 0;
#define	BLUE	red[i] = (char) 127; green[i] = (char) 127; blue[i] = (char) 255;
#define	PUREBLUE	red[i] = (char) 0; green[i] = (char) 0; blue[i] = (char) 255;
#define	LIGHTBLUE	red[i] = (char) 0; green[i] = (char) 0; blue[i] = (char) 255;
#define	YELLOW2	red[i] = (char) 200; green[i] = (char) 255; blue[i] = (char) 0;
#define	YELLOW	red[i] = (char) 255; green[i] = (char) 255; blue[i] = (char) 0;
#define	PURPLE	red[i] = (char) 255; green[i] = (char) 0; blue[i] = (char) 255;
#define	PURPLE2	red[i] = (char) 200; green[i] = (char) 0; blue[i] = (char) 255;
#define	PW1	red[i] = (char) 200; green[i] = (char) 0; blue[i] = (char) 255;
#define	PW2	red[i] = (char) 200; green[i] = (char) 100; blue[i] = (char) 255;
#define	PW3	red[i] = (char) 200; green[i] = (char) 130; blue[i] = (char) 255;
#define	PW4	red[i] = (char) 200; green[i] = (char) 160; blue[i] = (char) 255;
#define	PW5	red[i] = (char) 200; green[i] = (char) 190; blue[i] = (char) 255;
#define	PW6	red[i] = (char) 200; green[i] = (char) 220; blue[i] = (char) 255;
#define	WHITEB	red[i] = (char) 200; green[i] = (char) 255; blue[i] = (char) 255;


	switch(option){
	case (-1008): case (-1016): case (-1032): case (-1064): /* special contours with variable frequency */
		option += 1000; 
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		for (i=256+option; i>=110; i+=option) red[i] = green[i] = blue[i] = (char) 0;
		for (; i>0; i+=option) red[i] = green[i] = blue[i] = (char) 255;
		for (i=256+2*option; i<256 ; i-=option/4) red[i] = green[i] = blue[i] = (char) 0;
		i=1;
		RED
		break;

	case (-16): case (-8): case (-64): case (-32): /* normal with contours at 16s, 8s, 32s */
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		for (i=256+option; i>32; i+=option) red[i] = green[i] = blue[i] = (char) i-32;
		for (; i>16; i+=option) red[i] = green[i] = blue[i] = (char) i-16;
		i=0;
		RED	/* Note using 0=RED to make the grid come out grey */ 
		break;
	/* case (-16): case (-8): case (-64): case (-32): *//* OLD version normal with contours at 16s, 8s, 32s */
	/*	for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		for (i=256+option; i>=110; i+=option) red[i] = green[i] = blue[i] = (char) 0;
		for (; i>0; i+=option) red[i] = green[i] = blue[i] = (char) 255;
		i=1;
		RED
		break; */
	case (-2016): case (-2008): case (-2064): case (-2032): /* normal with fancy contours at 16s, 8s, 32s */
		option+=2000;
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		for (i=256+option; i>32; i+=option) red[i] = green[i] = blue[i] = (char) i-32;
		for (; i>16; i+=option) red[i] = green[i] = blue[i] = (char) i-16;
		i=1;
		DARKRED	/* this only differs from the first contour option in colours 0 and 1 */
		break;
	case (-3016): case (-3008): case (-3064): case (-3032): /* contours with hand-designed kludges for lpr */
		option+=3000;
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) MAX(i-16,0);
		for (i=256+option; i>48; i+=option) red[i] = green[i] = blue[i] = (char) i-48;
		for (; i>32; i+=option)red[i] = green[i] = blue[i] = (char) i-32;
		i=0;
		RED
		break;

	case (-416): case (-408): case (-464): case (-432): /* normal with fat contours at 16s, 8s, 32s */
		option+=100;
		k++;
	case (-316): case (-308): case (-364): case (-332): /* normal with fat contours at 16s, 8s, 32s */
		option+=100;
		k++;
	case (-216): case (-208): case (-264): case (-232): /* normal with fat contours at 16s, 8s, 32s */
		option+=200;
		k+=2;
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		for (i=256+option; i>128; i+=option)
			for(j=0;j<k;j++) red[i-j] = green[i-j] = blue[i-j] = (char) 0;
		for (; i-k+1>=0; i+=option) 
			for(j=0;j<k;j++) red[i-j] = green[i-j] = blue[i-j] = (char) 255;
		break;
	case(5016): case(5032): case(5048): case(5064): /* permuters */
	case(5080): case(5096): case(5112): case(5128): /* permuters */
	case(5144): case(5160): case(5176): case(5192): /* permuters */
	case(5208): case(5224): case(5240):             /* permuters */
		option-=5000;
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i+option;
		break;

	case (1): /* normal */
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		break;
	case (2): /* inverted */
		for (i=0; i<256; i++) red[255-i] = green[255-i] = blue[255-i] = (char) i;
		break;
	case (3): /* lousy yellow - blue */
		for (i=0; i<256; i++) red[255-i] = green[255-i] = blue[i] = (char) i;
		break;
	case (8): /* mauve thru blue thru green */
		for (i=0; i<256; i++){
			red[255-i] = green[i] = (char) i;
			blue[i] = (char) 180;
		}
		break;
	case (4): /* interesting red/orange - green - blue */
		for (i=0; i<256; i++){ 
			red[255-i] = blue[i] = (char) i; 
			green[i] = (char) 180;
		}
		break;
	case (14): /* interesting red/orange - green - blue , brighter than 4 */
		for (i=0; i<256; i++){ 
			red[255-i] = blue[i] = (char) i; 
			green[i] = (char) 200;
		}
		break;
	case (5): /* lousy red - green - blue */
		for (i=0; i<256; i++) red[255-i] = blue[i] = (char) i;
		for (i=0; i<128; i++) green[i] = green[255-i] = (char) 2*i; 
		break;
	case (9): /* red to blue 1 */ /* perhaps I prefer 7 to 9.. 7 has less green, etc */
		for (i=0,j=0; i<64; i++,j+=4){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (j=252; i<128; i++, j-=4){ 
			red[i] = (char) j; blue[i] = (char) 0; green[i] = (char) 255;}
		for (j=0; i<192; i++,j+=4){ 
			red[i] = (char) 0; blue[i] = (char) j; green[i] = (char)255;}
		for (j=252; i<256; i++,j-=4){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (92): /* red to blue to blue */ 
		for (i=0,j=0; i<32; i++,j+=8){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (j=248; i<64; i++, j-=8){ 
			red[i] = (char) j; blue[i] = (char) 0; green[i] = (char) 255;}
		for (j=0; i<96; i++,j+=8){ 
			red[i] = (char) 0; blue[i] = (char) j; green[i] = (char)255;}
		for (j=248; i<128; i++,j-=8){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		for (j=0; i<256; i++){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (93): /* red to blue to blue to blue */ 
		for (i=0,j=0; i<24; i++,j+=10){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (j=248; i<48; i++, j-=10){ 
			red[i] = (char) j; blue[i] = (char) 0; green[i] = (char) 255;}
		for (j=0; i<72; i++,j+=10){ 
			red[i] = (char) 0; blue[i] = (char) j; green[i] = (char)255;}
		for (j=248; i<96; i++,j-=10){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		for (; i<256; i++){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (94): /* red to blue to blue to blue to blue */ 
		for (i=0,j=0; i<16; i++,j+=16){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (j=248; i<32; i++, j-=16){ 
			red[i] = (char) j; blue[i] = (char) 0; green[i] = (char) 255;}
		for (j=0; i<48; i++,j+=16){ 
			red[i] = (char) 0; blue[i] = (char) j; green[i] = (char)255;}
		for (j=248; i<64; i++,j-=16){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		for (j=0; i<256; i++){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (9200): /* red lower half then red to blue */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)0;}
		for (i=0,j=0; i<32; i++,j+=8){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (j=248; i<64; i++, j-=8){ 
			red[i+128] = (char) j; blue[i+128] = (char) 0; green[i+128] = (char) 255;}
		for (j=0; i<96; i++,j+=8){ 
			red[i+128] = (char) 0; blue[i+128] = (char) j; green[i+128] = (char)255;}
		for (j=248; i<128; i++,j-=8){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (9300): /* red lower half then red to blue to blue */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)0;}
		for (i=0,j=0; i<24; i++,j+=10){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (j=248; i<48; i++, j-=10){ 
			red[i+128] = (char) j; blue[i+128] = (char) 0; green[i+128] = (char) 255;}
		for (j=0; i<72; i++,j+=10){ 
			red[i+128] = (char) 0; blue[i+128] = (char) j; green[i+128] = (char)255;}
		for (j=248; i<96; i++,j-=10){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (9400): /* red lower half then red to blue to blue to blue */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)0;}
		for (i=0,j=0; i<16; i++,j+=16){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (j=248; i<32; i++, j-=16){ 
			red[i+128] = (char) j; blue[i+128] = (char) 0; green[i+128] = (char) 255;}
		for (j=0; i<48; i++,j+=16){ 
			red[i+128] = (char) 0; blue[i+128] = (char) j; green[i+128] = (char)255;}
		for (j=248; i<64; i++,j-=16){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		for (j=0; i<128; i++){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (102): /* black lower half then black grey white */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 1; blue[i] = (char) 1; green[i] = (char) 1;}
		for (i=0,j=1; i<128; i++, j+=2){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		break;
	case (103): /* black lower half then black grey white in ~0.33, then white */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 1; blue[i] = (char) 1; green[i] = (char) 1;}
		for (i=0,j=0; i<85; i++, j+=3){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		break;
	case (104): /* black lower half then black grey white in 0.25, then white */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 1; blue[i] = (char) 1; green[i] = (char) 1;}
		for (i=0,j=1; i<64; i++, j+=4){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		break;
	case (106): /* black lower half then black grey white in ~0.16, then white */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 1; blue[i] = (char) 1; green[i] = (char) 1;}
		for (i=0,j=3; i<42; i++, j+=6){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		break;
	case (108): /* black lower half then black grey white in 0.125, then white */ 
		for (i=0; i<128; i++){ 
			red[i] = (char) 1; blue[i] = (char) 1; green[i] = (char) 1;}
		for (i=0,j=1; i<32; i++, j+=8){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) j; blue[i+128] = (char) j; green[i+128] = (char)j;}
		break;
	case (72): /* red lower half then red to blue */ 
		for (i=0,j=64; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (i=0; i<32; i++,j+=6){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (j=254,k=0; i<96; i++,j-=4, k+=4){ 
			red[i+128] = (char) j; blue[i+128] = (char) k; green[i+128] = (char)255;}
		for (j=254; i<128; i++,j-=4){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (73): /* red lower half then red to blue to blue */ 
		for (i=0,j=63; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (i=0; i<24; i++,j+=8){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (k=0; i<72; i++,j-=5, k+=5){ 
			red[i+128] = (char) j; blue[i+128] = (char) k; green[i+128] = (char)255;}
		for (j=254; i<96; i++,j-=6){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (74): /* red lower half then red to blue to blue */ 
		for (i=0,j=64; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (i=0; i<16; i++,j+=12){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (j=254,k=0; i<48; i++,j-=8, k+=8){ 
			red[i+128] = (char) j; blue[i+128] = (char) k; green[i+128] = (char)255;}
		for (j=254; i<64; i++,j-=8){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (76): /* red lower half then red to blue to blue */  /* this has an edge at yellow, due to 
	initial value of j */ 
		for (i=0,j=88; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (i=0; i<12; i++,j+=14){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (k=0; i<36; i++,j-=10, k+=11){ 
			red[i+128] = (char) j; blue[i+128] = (char) k; green[i+128] = (char)255;}
		for (j=254; i<48; i++,j-=12){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (78): /* red lower half then red to blue to blue to blue */ 
		for (i=0,j=64; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (i=0; i<8; i++,j+=24){ 
			red[i+128] = (char) 255; blue[i+128] = (char) 0; green[i+128] = (char)j;}
		for (j=254,k=0; i<24; i++,j-=16, k+=16){ 
			red[i+128] = (char) j; blue[i+128] = (char) k; green[i+128] = (char)255;}
		for (j=254; i<32; i++,j-=16){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		for (; i<128; i++){ 
			red[i+128] = (char) 0; blue[i+128] = (char) 255; green[i+128] = (char)j;}
		break;
	case (920): /* red to blue high gain */ 
		for (i=0,j=0; i<64; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (j=0; i<96; i++,j+=8){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (j=248; i<128; i++, j-=8){ 
			red[i] = (char) j; blue[i] = (char) 0; green[i] = (char) 255;}
		for (j=0; i<160; i++,j+=8){ 
			red[i] = (char) 0; blue[i] = (char) j; green[i] = (char)255;}
		for (j=248; i<192; i++,j-=8){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		for (j=0; i<256; i++){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (930): /* red to blue high gain high gain  */ 
		for (i=0,j=0; i<80; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (i=0,j=0; i<24; i++,j+=10){ 
			red[i+80] = (char) 255; blue[i+80] = (char) 0; green[i+80] = (char)j;}
		for (j=248; i<48; i++, j-=10){ 
			red[i+80] = (char) j; blue[i+80] = (char) 0; green[i+80] = (char) 255;}
		for (j=0; i<72; i++,j+=10){ 
			red[i+80] = (char) 0; blue[i+80] = (char) j; green[i+80] = (char)255;}
		for (j=248; i<96; i++,j-=10){ 
			red[i+80] = (char) 0; blue[i+80] = (char) 255; green[i+80] = (char)j;}
		for (; i+80<256; i++){ 
			red[i+80] = (char) 0; blue[i+80] = (char) 255; green[i+80] = (char)j;}
		break;
	case (940): /* red to blue high gain high gain high gain  */ 
		for (i=0,j=0; i<96; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (i=0,j=0; i<16; i++,j+=16){ 
			red[i+96] = (char) 255; blue[i+96] = (char) 0; green[i+96] = (char)j;}
		for (j=248; i<32; i++, j-=16){ 
			red[i+96] = (char) j; blue[i+96] = (char) 0; green[i+96] = (char) 255;}
		for (j=0; i<48; i++,j+=16){ 
			red[i+96] = (char) 0; blue[i+96] = (char) j; green[i+96] = (char)255;}
		for (j=248; i<64; i++,j-=16){ 
			red[i+96] = (char) 0; blue[i+96] = (char) 255; green[i+96] = (char)j;}
		for (j=0; i+96<256; i++){ 
			red[i+96] = (char) 0; blue[i+96] = (char) 255; green[i+96] = (char)j;}
		break;
	case (7): /* red to blue 2a -- more subjective than 70 */ 
		for (i=0,j=64; i<64; i++,j+=3){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (j=254,k=0; i<192; i++, j-=2, k+=2){ 
			red[i] = (char) j; blue[i] = (char) k; green[i] = (char) 255;}
		for (j=254; i<256; i++,j-=2){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (17): /* red to red to blue; steep gradient at end */ 
		for (i=0,j=64; i<128; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (j=64; i<160; i++,j+=6){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (j=254,k=0; i<224; i++, j-=4, k+=4){ 
			red[i] = (char) j; blue[i] = (char) k; green[i] = (char) 255;}
		for (j=254; i<256; i++,j-=4){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (27): /* red to red to red to blue; v steep gradient at end */ 
		for (i=0,j=64; i<192; i++){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (j=64; i<208; i++,j+=12){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (j=254,k=0; i<240; i++, j-=8, k+=8){ 
			red[i] = (char) j; blue[i] = (char) k; green[i] = (char) 255;}
		for (j=254; i<256; i++,j-=8){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (70): /* red to blue 2 --  */ 
		for (i=0,j=128; i<64; i++,j+=2){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (j=254,k=0; i<192; i++, j-=2, k+=2){ 
			red[i] = (char) j; blue[i] = (char) k; green[i] = (char) 255;}
		for (j=254; i<256; i++,j-=2){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		break;
	case (77): /* red to purple --  */ /* This needs more work */ 
		for (i=0,j=128; i<64; i++,j+=2){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char) j;}
		for (j=254,k=0; i<149; i++, j-=3, k+=3){ 
			red[i] = (char) j; blue[i] = (char) k; green[i] = (char) 255;}
		for (j=0; i<256; i++,j++){ 
			k=j*255/(256-149);
			red[i] = (char) k; blue[i] = (char) 255; green[i] = (char)255-k;}
		break;
	case (10): /* Goes round from red through ROYGBIV to red */ 
		for (i=0,j=0; i<42; i++,j+=6){ 
			red[i] = (char) 255; blue[i] = (char) 0; green[i] = (char)j;}
		for (j=250; i<84; i++, j-=6){ 
			red[i] = (char) j; blue[i] = (char) 0; green[i] = (char) 255;}
		for (j=0; i<126; i++,j+=6){ 
			red[i] = (char) 0; blue[i] = (char) j; green[i] = (char)255;}
		for (j=250; i<168; i++,j-=6){ 
			red[i] = (char) 0; blue[i] = (char) 255; green[i] = (char)j;}
		for (j=0; i<210; i++,j+=6){ 
			red[i] = (char) j; blue[i] = (char) 255; green[i] = (char)0;}
		for (j=250; i<252; i++,j-=6){ 
			red[i] = (char) 255; blue[i] = (char) j; green[i] = (char)0;}
		for (; i<256; i++){ 
			red[i] = (char) 255; blue[i] = (char) 255; green[i] = (char)0;}
		break;
	case(6): /* yellow to blue and intensity -- trashy */
		for (i=0; i<256; i++){ 
			red[i] = (char) ((i/16)*(15 - (i%16)));
			blue[i] = (char) ((i/16)*(i%16));
			green[i] = (char) ((i/16)*16);
		}
		break; /* This is for simultaneous plotting of intensity and colour 
			as the MSB and LSB, IE a 2D mapping: Do as follows: 
		merged image char = colour variable / 16 + (intensity / 16) * 16 */
	/* Perhaps problems becuase 0-255 <-> -127 - 128? */
	/* 127 seems to be black -- indeed, any single colour at 127 is very dim. */ /* No, the problem is just that 0-127 is invisible */

	case (67): /* red to blue 2a -- with intensity merge */ 
		r = ivector(0,15);
		b = ivector(0,15);
		g = ivector(0,15);
		for (i=0,j=4; i<4; i++,j+=3){ 
			r[i] = 15; b[i] =  0; g[i] =  j;}
		for (j=15,k=0; i<12; i++, j-=2, k+=2){ 
			r[i] =  j; b[i] =  k; g[i] = 15;}
		for (j=15; i<16; i++,j-=2){ 
			r[i] =  0; b[i] = 15; g[i] = j;}
		for (i=0; i<256; i++){ 
			red[i] = (char) ((i/32+9)*r[i%16]);
			blue[i] = (char) ((i/32+9)*b[i%16]);
			green[i] = (char) ((i/32+9)*g[i%16]); /* note I have 
				wasted one bit in this representation. There 
				are only 8 distinct brightnesses. */ 
		/* also, green is a bit too broad -- alittle m work and this will be good */ 
		}
		break;
	case (1000): /* red to blue to red, with 16 levels of intensity and 
16 of colour  */ 
		r = ivector(0,15);
		b = ivector(0,15);
		g = ivector(0,15);

		for (i=0,j=5,k=10; i<6; i++,j+=2,k-=2){ 
			r[i] = 15; b[i] =  k; g[i] =  j;}
		for (j=12,k=0; i<10; i++, j-=3, k+=3){ 
			r[i] =  j; b[i] =  k; g[i] = 15;}
		for (j=15,k=5; i<15; i++,j-=2,k+=2){ 
			r[i] =  k; b[i] = 15; g[i] = j;}
		for (; i<16; i++,j-=2,k+=2){ 
			r[i] =  k; b[i] = 12; g[i] = j;}
		for (i=0; i<256; i++){ 
			red[i] = (char) (((i/16)*r[i%16]*8)/15+15*r[i%16]/2);
			blue[i] = (char) (((i/16)*b[i%16]*8)/15+15*b[i%16]/2);
			green[i] = (char) (((i/16)*g[i%16]*8)/15+15*g[i%16]/2);  
		}
		i=1;
		WHITE
		break;
	case (1016): /* w to b to w, with 16 levels of intensity   */ 
		r = ivector(0,15);
		b = ivector(0,15);
		g = ivector(0,15);

		for (i=0; i<8; i++){ 
			r[8+i] =  b[8+i] =   g[8+i] =  i +8;
			r[7-i] =  b[7-i] =   g[7-i] =  i+8;}
		for (i=0; i<256; i++){ 
			red[i] = (char) (((i/16)*r[i%16]*8)/15+15*r[i%16]/2);
			blue[i] = (char) (((i/16)*b[i%16]*8)/15+15*b[i%16]/2);
			green[i] = (char) (((i/16)*g[i%16]*8)/15+15*g[i%16]/2);  
		}
		i=1;
		RED
		break;
	case (2016): /* oscillating ramp   */ 
		amplitude = 50; period=16;
		for (i=0; i<256; i++) 
			red[i] = 
			blue[i] = 
			green[i] = (char)((double)(i)*(256.0-2.0*amplitude)/256.0+amplitude*(1.0+sin((double)(i)*2.0*PI/period)) );  
		i=1;
		RED
		break;
	case (3008): /* w to b to w, with 8 levels of intensity ramp instead of continuous saw tooth  */ 
		r = ivector(0,7);
		b = ivector(0,7);
		g = ivector(0,7);

		for (i=0; i<8; i++) 
			r[i] =  b[i] =   g[i] =  i +8;
		for (i=0; i<256; i++){ 
			red[i] = (char) (((i/8)*r[i%8]*4)/15+15*r[i%8]/2);
			blue[i] = (char) (((i/8)*b[i%8]*4)/15+15*b[i%8]/2);
			green[i] = (char) (((i/8)*g[i%8]*4)/15+15*g[i%8]/2);  
		}
		i=0;
		RED
		break;
	case (3016): /* w to b to w, with 8 levels of intensity ramp instead of continuous saw tooth  */ 
		r = ivector(0,15);
		b = ivector(0,15);
		g = ivector(0,15);

		for (i=0; i<15; i++) 
			r[i] =  b[i] =   g[i] =  i +16;
		for (i=0; i<256; i++){ 
			red[i] = (char) (((i/16)*r[i%16]*4)/15+15*r[i%16]/4);
			blue[i] = (char) (((i/16)*b[i%16]*4)/15+15*b[i%16]/4);
			green[i] = (char) (((i/16)*g[i%16]*4)/15+15*g[i%16]/4);  
		}
		i=0;
		RED
		break;
	case (167): /* red to blue 2a -- with intensity merge and improvements */ 
		r = ivector(0,15);
		b = ivector(0,15);
		g = ivector(0,15);

		for (i=0,j=5; i<6; i++,j+=2){ 
			r[i] = 15; b[i] =  0; g[i] =  j;}
		for (j=12,k=3; i<10; i++, j-=3, k+=3){ 
			r[i] =  j; b[i] =  k; g[i] = 15;}
		for (j=15; i<16; i++,j-=2){ 
			r[i] =  0; b[i] = 15; g[i] = j;}
		for (i=0; i<256; i++){ 
			red[i] = (char) (((i/16)*r[i%16]*8)/15+15*r[i%16]/2);
			blue[i] = (char) (((i/16)*b[i%16]*8)/15+15*b[i%16]/2);
			green[i] = (char) (((i/16)*g[i%16]*8)/15+15*g[i%16]/2);  
		}
		break;
	case (177): /* red to purple with intensity merge  */ 
		r = ivector(0,15);
		b = ivector(0,15);
		g = ivector(0,15);

		for (i=0,j=6; i<3; i++,j+=3){ 
			r[i] = 15; b[i] =  3; g[i] =  j;}
		r[i] = 14; b[i] =  3; g[i] =  11; /* special treatment to reduce the yellow band */ 
		i++;
		r[i] = 14; b[i] =  3; g[i] =  15; /* special treatment to reduce the yellow band */ 
		i++;
		for (j=8,k=6; i<8; i++, j-=3, k+=3){ 
			r[i] =  j; b[i] =  k; g[i] = 15;}
		for (j=15,k=1; i<16; i++,j-=2,k+=2){ 
			r[i] =  k; b[i] = 15; g[i] = j;}
		for (i=0; i<256; i++){ 
			red[i] = (char) (((i/16)*r[i%16]*8)/15+15*r[i%16]/2);
			blue[i] = (char) (((i/16)*b[i%16]*8)/15+15*b[i%16]/2);
			green[i] = (char) (((i/16)*g[i%16]*8)/15+15*g[i%16]/2);  
		}
		break; /* This is best except for an error with an orange intensity */
	case (700): /* finger print discrete colour table */
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		i=0; WHITE
		i=1; GREY
		i=2; BLACK
		i=3; RED
		i=4; GREEN
		i=5; BLUE
		i=255; DARKRED
		break;
	case (800): /* depth discrete colour table */
		for (i=0; i<256; i++) red[i] = green[i] = blue[i] = (char) i;
		i=0; BLACK
		i=1; WHITE
		i=2; DARKRED
		i=3; PUREBLUE
		i=4; PUREGREEN
		i=5; PURPLE2
		i=6; YELLOW2
		i=7; LIGHTBLUE
		i=8; PURPLE 
		i=9; PW1 i=10; PW2 i=11;PW3 i=12;PW4 i=13;PW5 i=14;PW6 i=15;WHITEB
		i=255; 
		break;
	default: 
		for (i=0; i<256; i++){ red[255-i] = blue[i] = (char) i; green[i] = (char) option;}
		break;

	}
}


/*************    Scale_Image     ***************/

void	Scale_Image( Image, Xsize, Ysize, min_value, max_value )
	int	Xsize,Ysize;
	double	**Image, min_value, max_value;
{
	int	i, j;
	double	mini, maxi, scale;

	maxi = mini = Image[0][0];
	for (i=1; i<Xsize-1; i++)
		for (j=1; j<Ysize; j++)   {
			if (Image[i][j] > maxi)
				maxi = Image[i][j];
			if (Image[i][j] < mini)
				mini = Image[i][j];
		}
	scale = (max_value - min_value) / (maxi - mini);
	for (i=0; i<Xsize; i++)
		for (j=0; j<Ysize; j++)
			Image[i][j] = (Image[i][j] - mini)*scale + min_value;
}

