/*  Program to normalise a datafile.  */
/*  Can be used to normalise the initial database or a testing set */
/*  long as the proper number of columns is passed as argument.    */
/*  USAGE:                                                         */
/*  normalise no_of_lines no_of_columns MinMax_file_name Database  */
/*            output_file_name                                     */
/*  T.Sourmail, 05/2000                                            */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

int main(int argc, char *argv[])
{
  FILE *ifp,*ofp;
  int i=0,j=0,no_of_lines,no_of_columns;
  char minmax_file[100],data_file[100],out_file[100],c;
  float dummy,mean,stdev;
  float min[50],max[50],datain[50],dataout[50];

  if(argc == 3) {
    printf("\n\n%s ","You have not precised the name of the minmax, database");
    printf("%s\n","and output files.");
    printf("%s\n"," Using MINMAX,test.dat and norm_test.in by default\n");
    strcpy(minmax_file,"MINMAX");
    strcpy(data_file,"test.dat");
    strcpy(out_file,"norm_test.in");
    no_of_lines=atoi(argv[1]);
    no_of_columns=atoi(argv[2]);    
    }
  if(argc == 6) {
    strcpy(data_file,argv[1]);
    no_of_lines=atoi(argv[2]);
    no_of_columns=atoi(argv[3]); 
    strcpy(minmax_file,argv[4]);
    strcpy(out_file,argv[5]);
  }
  if(argc != 3 && argc != 6){
    printf("\n\n%s %s %s\n\n","Usage:",argv[0],"[database name][no_of_lines][no_of_columns][Min_Max_file][Output file]");
    printf("%s %s %s\n\n","OR",argv[0],"no_of_lines no_of_input_variables");
    printf("%s","\nMINMAX, test.dat and norm_test.in are then used by default\n");
    exit(0);
  }

/*    printf("%s %s %s\n","WARNING:",argv[0],"strips out the first line of your"); */
/*    printf("%s\n","database so that you can leave the labels."); */



/*  READ AND STORE THE MIN AND MAX FOR EACH VARIABLE */
/*   Warning: working with MINMAX as generated by innorn6.c, not the fortran version */
  if((ifp=fopen(minmax_file,"r")) == NULL) {
    printf("Error in %s: unable to find file %s\n",argv[0],minmax_file);
    exit(0);
  }
  else {
    while((c=getc(ifp)) != '\n');
    while (++i<=(no_of_columns))
      fscanf(ifp,"%f%f%f%f%f%f",&min[i],&max[i],&dummy,&dummy,&mean,&stdev);
    fclose(ifp);
  }

/*  READ AND NORMALISE */

  if((ifp=fopen(data_file,"r")) == NULL || (ofp=fopen(out_file,"w")) == NULL) {
    printf("\nError in %s: unable to find file %s\n",argv[0],minmax_file);
    printf("Or to create %s.\n",out_file);
    exit(0);
  }

  else {

/*  IS THERE A LINE WITH THE LABELS AT THE BEGINNING ? */

    if((fscanf(ifp,"%f",&dummy)) != 1) {
    while((c=getc(ifp)) != '\n');
    ++j;
    }
    else {
      rewind(ifp);
    }

    while(++j<=no_of_lines) {
      i=0;
      while(++i<=no_of_columns) {
	fscanf(ifp,"%f",&datain[i]);
	if(min[i] != max[i]) {
	  dataout[i]=(datain[i]-min[i])/(max[i]-min[i])-0.5;
	    }
	else {
	  dataout[i]=0;
	    }
	fprintf(ofp,"%9.8f ",dataout[i]);
      }
	  while((c=getc(ifp)) != '\n' && j<no_of_lines);
      fprintf(ofp,"\n");
    }
  }

  printf("%s %s %s %s\n","Database",argv[1],"normalised, output written to:",out_file);
}





