C
C University of Cambridge, 18-03-00
C Carlos Capdevila
C Program to calculate the volume fraction of recrystallisation in a 
C ODS Fe base alloy as a function of deformation level and constant 
C heating rate.
C
C Grain-twist project
C
C Paper:
C	Bhadeshia & Sha, Met. Sci. Eng., A223, 1997, pp. 91-98
C      

      IMPLICIT NONE
	  INTEGER I,J2,II,IJ3,J3,I2
      DOUBLE PRECISION TIME(1000),HR,HRS,DEF,ID,deflevel,
     &  TM,VOLR(1000),TIME2,AB2,TMIN,CTEMP(1000),KTEMP(1000),TIME3,
     &  AV,VEL(1000),NUCL(1000),RECRYS(1000),G,NUCDEF(1000),GDEF(1000)
C
	 OPEN(3,FILE='anniso.out')
	open(12,file='nucrate.out')
C
C
C Constants
C TM melting temperature in C;
C Counter
C
	 TM=1482.0D+00
	 TMIN=700.0D+00
	 AB2=2.0D+00
	 J2=INT((TM-TMIN)/AB2)-1
C
C Heating Rate
C
	 WRITE(*,2)
	 READ(*,*)HR
	 HRS=HR/60.0D+00
C
C Deformation level 
C
	 WRITE(*,22)
	 READ(*,*)deflevel
C
C Headres
C
	 WRITE(*,3)
	 WRITE(3,3)
C
C Reset parameters
C
	 TIME2=0.0D+00
	 TIME3=0.0D+00
	 IJ3=1
	 DO 1 II=1,J2
		TIME(II)=0.0D+00
		VOLR(II)=0.0D+00
1	 CONTINUE
C
C Calculations for each heating rate (Scheils's Rule)
C
	 DO 110 I=1,J2
		def=deflevel
	   J3=INT(I/5.0D+00)
	   CTEMP(I)=TMIN+AB2*I
	   KTEMP(I)=CTEMP(I)+273.14D+00
C
	   IF (I.EQ.1) THEN
	       	CALL VOLREC(VOLR(I),KTEMP(I),DEF,TIME(I))
	   ELSE
		AV=VOLR(I-1)
		CALL ATIM(KTEMP(I),TIME2,AV,DEF)
		TIME3=TIME2+ab2/hrs
C
C Calculation of the constant Nucleation Rate
C
	        CALL NUCVEL(DEF,KTEMP(I),NUCL(I),G)
C
C Calculation of the grain-boundary velocity
C
	        CALL GBVEL(KTEMP(I),VEL(I))
C
C Evolution of the fraction of recrystallisation
C
	       	CALL VOLREC(VOLR(I),KTEMP(I),DEF,TIME3)
	   END IF
C
C Print Results
C
	   RECRYS(I)=VOLR(I)
	   IF (RECRYS(I).LE.1.0D-06) RECRYS(I)=0.0D+00
	   IF (J3.EQ.IJ3) THEN
	   	IJ3=IJ3+1
		WRITE(*,4)CTEMP(I),(RECRYS(I)*100),NUCL(I),VEL(I)
	   	WRITE(3,4)CTEMP(I),(RECRYS(I)*100),NUCL(I),VEL(I)
C
	   ENDIF
110	 CONTINUE
C
C Calculation for each level of deformation
C
	 DO 20 ID=0,100,10
	  WRITE(12,51)ID	
	  DO 10 I2=1,J2,20
	    CALL NUCVEL(ID,KTEMP(I2),NUCDEF(I2),GDEF(I2))
	    WRITE(12,55)CTEMP(I2),NUCDEF(I2),GDEF(I2)
10	  CONTINUE
20	 CONTINUE
C
C~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~FORMAT Statements~~~~~~~~~~~~~~~~~~~~~~~~~~
C
51	 FORMAT(5X,'Level of deformatio =',F4.0,'%')
55	 FORMAT(3(2X,E14.6))
2	 FORMAT(10X,'Heating Rate (C/min)?',/)
22	 FORMAT(10X,'Deformation level in %?',/)
3	 FORMAT(2X,'Temperature',5X,'Frac._Rec.',10x,'NUC_Rate',10x,
     &     'GB_Velocity',/)
4	 FORMAT(5x,F5.0,3(5X,E14.6))
C
C~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
	 STOP
	 END
C
C**************************************************************************
C Sub-routine to calculate the volume fraction of recrystallised material
C in ODS 
C
C University of Cambridge, 15-01-98
C Carlos Capdevila
C
	SUBROUTINE VOLREC(VOLFRAC,T,defor,ISOTIME)
	IMPLICIT NONE
	DOUBLE PRECISION VELB,NUCRATE,VOLFRAC,T,ISOTIME,defor,EXPONENT,G
	double precision def
C
	def=defor
C
C Nucleation and growth velocities (T in K)
C
	CALL NUCVEL(def,T,NUCRATE,G)
	CALL GBVEL(T,VELB)

	EXPONENT=NUCRATE*(VELB**3.0D+00)*(ISOTIME**4.0D+00)
	EXPONENT=EXPONENT/4.0D+00
	VOLFRAC=1.0D+00-DEXP(-EXPONENT)
C
	RETURN
	END
C
C**************************************************************************
C Sub-routine to calculate the grain boundary velocity in ODS 
C as a function of experimental results 
C

	SUBROUTINE GBVEL(KTEMP,VELOCITY)
	IMPLICIT NONE
	DOUBLE PRECISION VELOCITY1,VELOCITY2,KTEMP,VELOCITY
C
C Deformation do not affect to grain boundary velocity
C Grain boundary velocity in long. direction. Maximum
C
	VELOCITY1=dexp(21.995d+00-(51586.0d+00/ktemp))
C
C Grain boundary velocity in cross. direction. Minimum
C
	VELOCITY2=dexp(41.91d+00-(90021.0d+00/ktemp))
C
C Final 
	velocity=velocity1*velocity2
	velocity = sqrt(velocity)
C Units: m/s
C
	RETURN
	END
C
C**************************************************************************
C Sub-routine to calculate the nucleation rate in accordance to epirical data
C as a function of deformation level.	
C
C University of Cambridge, 6-11-98
C Carlos Capdevila
C
	SUBROUTINE NUCVEL(deflevel,KTEMP,NUCLEAT,GTR)
	IMPLICIT NONE
	DOUBLE PRECISION DEF,NUCLEAT,KTEMP,TR,KTR,VELTR,R
	DOUBLE PRECISION NUCTR,TIMETR,VGRAIN,GTR,FREQ,MANTISA
	DOUBLE PRECISION MANTISA2,ACTIVENER,deflevel
C
	def=deflevel
C
C Constants:
C R=Gas constant in (J/K mol)
C FREQ=Vibration frequency (McLellan) in s**-1
C
	R=8.314D+00
	FREQ=1.3D+09
C
C Deformation level in %
C Minimum recrystallisation temperature (TR) after 1 hour isothermal 
C holding time as a function of deformation level (EMPIRICAL)
C
	TR=1750.6d+00*((def/100.0d+00)**2.0d+00)-1706.7d+00*
	&        (def/100.0d+00)+1315.5d+00
	KTR=TR+273.00D+00
C
	IF (KTEMP.LE.KTR) THEN					     
		NUCLEAT = 0.0D+00
		GTR = 0.0D+00
		GOTO 1
	ELSE
C
C Empirical test for TR 
C	Holding time = 1 hour
C	Recrystallisation fraction = 5%
		CALL GBVEL(KTR,VELTR)
		TIMETR=3600.00D+00
		NUCTR=DLOG(0.95D+00)/((VELTR**3.0D+00)*(TIMETR**4.0D+00))
		NUCTR=-4.0D+00*NUCTR
C
C Volume of the grain as a function of deformation (m**3)
C
c		VGRAIN=4.0d-21*def+6.0d-20
		VGRAIN=5.0d-21*def+1.0d-19
C
C Activation energy for nucleation as a function of deformation
C
		MANTISA=(NUCTR*VGRAIN)/(4.0D+00*FREQ)
		ACTIVENER=DABS(DLOG(MANTISA)*R*KTR)
C
C Nucleation rate
C
		MANTISA2=-(ACTIVENER/(R*KTEMP))
		NUCLEAT=(4.0D+00/VGRAIN)*FREQ*DEXP(MANTISA2)
		GTR=ACTIVENER

	ENDIF
C
1	RETURN
	END
C
C*****************************************************************
C
C Calculates time required to transform to a given volume fraction
C
       SUBROUTINE ATIM(KTEMP,TIME,VOL,DEF)
C
	IMPLICIT NONE
        DOUBLE PRECISION KTEMP,TIME,VOL,NUCLEAT,VELB,F1,F2,DEF,G
C
C Nucleation and growth rates
C
	CALL NUCVEL(DEF,KTEMP,NUCLEAT,G)
	CALL GBVEL(KTEMP,VELB)
	IF (NUCLEAT.EQ.0.0D+00) THEN
		TIME=0.0D+00
		GOTO 2
	ENDIF
C
C Functions
C
	F2=NUCLEAT*(VELB**3.0D+00)
	IF (VOL.GE.0.999D+00) VOL=0.999D+00
	F1=-4.0D+00*DLOG(1.0D+00-VOL)
C
C Time
C
	TIME=(F1/F2)**0.25D+00
C
2     RETURN
      END
C
