C H. K. D. H. Bhadeshia, University of Cambridge
C
C Program to calculate the parabolic rate constant for variable
C diffusion coefficient using Atkinson's numerical analysis method
C Ref: Acta Metall., vol.16 (1968) 1019. ***6 Aug 1985***
C Terminology is the same as in Atkinson's paper.
C Program applied to the problem of ferrite growth from austenite in a low
C alloy steel.
C XGAG = Carbon concentration in austenite at the interface.
C XBAR = Carbon concentration in austenite, at infinity away from interface.
C N    = Number of steps into which the concentration profile is divided.
C
C Uses Nag subroutines
C Typical data
C 0.12 0.49 1.16 0.0 0.0 0.0 0.0 0.0 0.0
C 780 0.0100
C 700 0.0266
C
      IMPLICIT REAL*8(A-H,O-Z), INTEGER(I-N)
      DOUBLE PRECISION ETA(300),F(300),G(300),C(8)
      DOUBLE PRECISION MAP_STEEL_XALPH
      CHARACTER*1 ANS
C
C  BOLTZ is the Boltzmann constant (in Joules per Kelvin, J/K)
C  R is the molar gas constant (in Joules per mole per Kelvin, J/(mol K))
C  HH is the Planck constant (in Joules per Hertz, J/Hz)
C
      BOLTZ=1.380658D-23
      R=8.31451D+00
      HH=6.6260755D-34
      WRITE (*,*) 'Input  C,  Si,  Mn,  Ni,  Mo,  Cr,  V wt%:'
      READ (5,*) C(1),C(2),C(3),C(4),C(5),C(6),C(7)
      IJ = 0
      WRITE(*,1)
      WRITE(*,2) C(1),C(2),C(3),C(4),C(5),C(6),C(7)
      CALL MAP_STEEL_OMEGA(C,W,XBAR,T10,T20,IJ)
      WRITE(*,3) C(1),C(2),C(3),C(4),C(5),C(6),C(7)
      WRITE(*,4) W,XBAR
  100 ALPHA = 0.0D0
      WRITE(*,*) 'Input temperature (deg.C) ',
     &           'and C mole fraction in austenite at the interface:'
      READ (*,*) CTEMP, XGAG
      WRITE(*,5) CTEMP,XGAG
      TTEMP = CTEMP + 273D0
      N = 10
      GOTO 120
  110 N = N+50
      IF (N .GT. 200) GOTO 180
  120 XALPHA = MAP_STEEL_XALPH(TTEMP)
      CALL MAP_STEEL_DIFFUS(DIF0,XGAG,TTEMP,W,R,BOLTZ,HH)
      IF ( N.EQ.10 ) THEN
         WRITE(*,6) XALPHA,DIF0
         WRITE(*,7)
      ENDIF
      N1 = N-1
      CALL GEE(G(1),CTEMP,XGAG,XBAR,W,ALPHA)
      DO 130 I=1,N1
         CI   = XGAG-I*((XGAG-XBAR)/N)+0.5D0*(XGAG-XBAR)/N
         CALL MAP_STEEL_DIFFUS(DIF,CI,TTEMP,W,R,BOLTZ,HH)
         F(I) = DIF/DIF0
  130 CONTINUE
  140 ETA(1) = F(1)/G(1)
C
C read J as 0, 1, 2, ....
C read I as 0.5, 1.5, 2.5.......for CI and F(I)
C
      DO 150 I=2,N1
         J = I
         G(I)   = G(I-1)-2.0D0*ETA(J-1)-ALPHA
         ETA(J) = ETA(J-1)+F(I)/G(I)
  150 CONTINUE
      CALL STAR(GSTAR,F(N1),ETA(N1),ALPHA)
      RESDU1 = DABS(G(N1)-GSTAR)
      IF (RESDU1 .LT. 1.0D-4) GOTO 160
      G(1) = DABS(G(1)-0.5D0*(G(N1)-GSTAR))
      GOTO 140
  160 ALPH = ((XBAR-XGAG)/N)/((XALPHA-XGAG)*ETA(1))
      RESDU2 = DABS(ALPH-ALPHA)
      IF (RESDU2 .LT. 1.0D-6) GOTO 170
      ALPHA = ALPH
      GOTO 140
  170 ALPH  = ALPH*DSQRT(DIF0)
      WRITE(*,8) N,ALPH,RESDU1,RESDU2
      GOTO 110
  180 WRITE(*,*) 
      WRITE(*,*) 'Repeat calculations for another set of data (y/n)?'
      READ (*,*) ANS
      IF ( ANS .EQ. 'y' .OR. AND .EQ. 'Y' ) GOTO 100
      STOP
    1 FORMAT(//'****************************************************'
     &         '**********************'//
     &         ' Element:       C      Si      Mn      Ni      Mo'
     &         '      Cr      V')
    2 FORMAT(  ' conc. wt%: ',7(F7.4,X))
    3 FORMAT(  ' mole frac: ',7(F7.4,X)/)
    4 FORMAT(' Carbon-carbon interaction energy in austenite = ',F7.1,
     &       ' J/mol'/
     &       ' Starting mole fraction of carbon in austenite = ',F7.4//)
    5 FORMAT(//' Temperature = ',F7.2,
     &         ' deg. C'/
     &       ' Equ. C conc. in austenite at the interface =', F7.4,
     &       ' mole fractions')
    6 FORMAT(' Equ. C conc. in ferrite at the interface   =', D11.4,
     &       ' mole fractions'/
     &       ' Diffusivity of carbon in austenite (Do)    =', D11.4, 
     &       ' squ.cm/s'/)
    7 FORMAT( ' No. steps',2X,'Rate constant (cm/s**0.5)',2X,
     &        'Residue 1',2X,'Residue 2')
    8 FORMAT(3X,I4,12X,D11.4,8X,D10.3,1X,D10.3)
      END
C***************************************************************************
      SUBROUTINE STAR(GSTAR,F,ETA,ALPHA)
      IMPLICIT REAL*8(A-H,O-Z)
C
      X = (ETA+0.5D0*ALPHA)/DSQRT(F)
      IF (X .GT. 5.0D0) GOTO 100
      X = (2.0D0*X*DEXP(-X*X)/((DSQRT(3.142D0))*DERFC(X)))-2.0D0*X*X
      GOTO 110
  100 X = -2.0D0*X*X
  110 GSTAR = (F*X/(ETA+0.5D0*ALPHA))+ETA+0.5D0*ALPHA
      RETURN
      END
C***************************************************************************
      SUBROUTINE GEE(G,CTEMP,XMAX,XBAR,W,ALPHA)
      IMPLICIT REAL*8(A-H,O-Y), INTEGER(I-N,Z)
      DOUBLE PRECISION DFF(1000),CARB(1000)
      DOUBLE PRECISION MAP_STEEL_CG,MAP_STEEL_DCG
C
      BOLTZ = 1.38062D-23
      HH = 6.6262D-34
      A5 = 1.0D+00
      R  = 8.3143D+00
      Z  = 12
      T  = CTEMP+273.0
      II2  = 0
      DASH = (BOLTZ*T/HH)*DEXP(-(21230.0D0/T))*DEXP(-31.84D0)
      CARB(1) = XBAR
      DO 150 II=1,1000
         IF (II .GT. 1) GOTO 100
         GOTO 140
  100    IF (CTEMP .GT. 700.0) GOTO 110
         GOTO 120
  110    XINCR = 0.0001D0
         GOTO 130
  120    XINCR = 0.001D0
  130    CARB(II) = CARB(II-1)+XINCR
         IF (CARB(II) .GT. XMAX) GOTO 160
  140    X = CARB(II)
         II2 = II2+1
         THETA  = X/(A5-X)
         ACTIV  = MAP_STEEL_CG(X,T,W,R)
         ACTIV  = DEXP(ACTIV)
         DACTIV = MAP_STEEL_DCG(X,T,W,R)
         DACTIV = DACTIV*ACTIV
         DACTIV = DACTIV*A5/((A5+THETA)**2)
         SIGMA  = A5-DEXP((-W)/(R*T))
         PSI    = ACTIV*(A5+Z*((A5+THETA)/(A5-(A5+Z/2)*THETA+(Z/2)*
     &            (A5+Z/2)*(A5-SIGMA)*THETA*THETA)))+(A5+THETA)*DACTIV
         DFF(II)= DASH*PSI*(X-XBAR)
  150 CONTINUE
  160 II3 = 0
C
C  Alternative NAG routine: CALL D01GAF(CARB,DFF,II2,ANS,ERROR,II3) 
C
      CALL MAP_UTIL_TRAPE(CARB,DFF,ANS,II2)
      ANS = 2.0D0*ANS/((XMAX-XBAR)**2.0D0)
      CALL MAP_STEEL_DIFFUS(DIF0,XMAX,T,W,R,BOLTZ,HH)
      IF (ALPHA .GT. 0.0D0) THEN
         G = (2.0D0*II2*DSQRT(ANS/DIF0))/(DSQRT(3.14159D0))+
     &       ALPHA*(II2-0.5D0)
      ELSE
         G = (2.0D0*II2*DSQRT(ANS/DIF0))/(DSQRT(3.14159D0))
      ENDIF
      RETURN
      END
C***************************************************************************
C the infulence of C, Mn, Si, Ni, Mo, Cr and V on the activity of carbon
C in austenite, and therefore on the diffusivity of carbon.
C
C WDIFF is the carbon--carbon interaction energy in austenite, not
C allowing for the presence of Mo, Cr or V
C
C diffusion coefficient in cm**/s
C
      SUBROUTINE MAP_STEEL_DIFFUS(DIF,X,T,W,R,BOLTZ,HH)
      IMPLICIT NONE
      DOUBLE PRECISION DIF,X,T,W,PSI,THETA,ACTIV,DACTIV,DASH,SIGMA,A5
      DOUBLE PRECISION BOLTZ,HH,R,MAP_STEEL_DCG,MAP_STEEL_CG
      INTEGER IZ
         IZ=12
         A5=1.0D+00
C     DIF=DIFFUSIVITY OF CARBON IN AUSTENITE
C     IZ=COORDINATION OF INTERSTIAL SITE
C     PSI=COMPOSITION DEPENDENCE OF DIFFUSION COEFFICIENT
C     THETA=NO. C ATOMS/ NO. FE ATOMS
C     ACTIV=ACTIVITY OF CARBON IN AUSTENITE
C     R=GAS CONSTANT
C     X=MOLE FRACTION OF CARBON
C     T=ABSOLUTE TEMPERATURE
C     SIGMA=SITE EXCLUSION PROBABLITY
C     W=CARBON CARBON INTERACTION ENERGY IN AUSTENITE
C
      DASH=(BOLTZ*T/HH)*DEXP(-(21230.0D+00/T))*DEXP(-31.84D+00)
      THETA=X/(A5-X)
      ACTIV=MAP_STEEL_CG(X,T,W,R)
      ACTIV=DEXP(ACTIV)
      DACTIV=MAP_STEEL_DCG(X,T,W,R)
      DACTIV=DACTIV*ACTIV
      DACTIV=DACTIV*A5/((A5+THETA)**2)
      SIGMA=A5-DEXP((-(W))/(R*T))
      PSI=ACTIV*(A5+IZ*((A5+THETA)/(A5-(A5+IZ/2)*THETA+(IZ/2)*(A5+IZ/2)*
     &(A5-SIGMA)*THETA*THETA)))+(A5+THETA)*DACTIV
      DIF=DASH*PSI
      RETURN
      END
C*******************************************************************************
C CG CG DOUBLE PRECISION FUNCTION GIVING LFG  LN(ACTIVITY) OF CARBON IN
C AUSTENITE
      DOUBLE PRECISION FUNCTION MAP_STEEL_CG(X,T,W,R)
      IMPLICIT NONE
      DOUBLE PRECISION AJ,DG,EG,T,R,W,X
      AJ=1.0-DEXP(-W/(R*T))
         IF(X .LE. 1.0D-10) THEN
           MAP_STEEL_CG=DLOG(1.0D-10)
         ELSE
           DG=DSQRT(1.0-2.0*(1.0+2.0*AJ)*X+(1.0+8.0*AJ)*X*X)
           EG=5.0*DLOG((1.0-2.0*X)/X)+6.0*W/(R*T)+
     &     (38575.0-13.48*T)/(R*T)
           MAP_STEEL_CG=EG+6.0D+00*DLOG((DG-1+3*X)/(DG+1-3*X))
         ENDIF
      RETURN
      END
C*******************************************************************************
C DCG DCG
C FUNCTION GIVING DIFFERENTIAL OF LN(ACTIVITY) OF CARBON IN AUSTENITE, LFG
C DIFFERENTIAL IS WITH RESPECT TO X
      DOUBLE PRECISION FUNCTION MAP_STEEL_DCG(X,T,W,R)
      IMPLICIT NONE
      DOUBLE PRECISION AJ,DG,DDG,X,T,W,R
      AJ=1.0-DEXP(-W/(R*T))
      DG=DSQRT(1.0-2.0*(1.0+2.0*AJ)*X+(1.0+8.0*AJ)*X*X)
      DDG=(0.5/DG)*(-2.0-4.0*AJ+2.0*X+16.0*AJ*X)
      MAP_STEEL_DCG=-((10.0/(1.0-2.0*X))+(5.0/X))+6.0*((DDG+3.0)
     &/(DG-1.0+3.0*X)-(DDG-3.0)/(DG+1.0-3.0*X))
      RETURN
      END
C*******************************************************************************
      SUBROUTINE MAP_STEEL_OMEGA(C,W,XBAR,T10,T20,J)
C SUBROUTINE TO CALCULATE THE CARBON CARBON INTERACTION ENERGY IN
C AUSTENITE, AS A FUNCTION OF ALLOY COMPOSITION.  BASED ON .MUCG18
C THE ANSWER IS IN JOULES PER MOL.   **7 OCTOBER 1981**
      IMPLICIT NONE
      DOUBLE PRECISION C(8),W,P(8),B1,B2,Y(8),T10,T20,B3,XBAR
      INTEGER IU,J
      B3=0.0D+00
      IF(J .EQ. 1) GOTO 2
      C(8)=C(1)+C(2)+C(3)+C(4)+C(5)+C(6)+C(7)
      C(8)=100.0D+00-C(8)
      C(8)=C(8)/55.84D+00
      C(1)=C(1)/12.0115D+00
      C(2)=C(2)/28.09D+00
      C(3)=C(3)/54.94D+00
      C(4)=C(4)/58.71D+00
      C(5)=C(5)/95.94D+00
      C(6)=C(6)/52.0D+00
      C(7)=C(7)/50.94D+00
2     B1=C(1)+C(2)+C(3)+C(4)+C(5)+C(6)+C(7)+C(8)
      DO 107 IU=2,7
      Y(IU)=C(IU)/C(8)
107   CONTINUE
      DO 106 IU=1,8
      C(IU)=C(IU)/B1
106   CONTINUE
      XBAR=C(1)
      XBAR=DINT(10000.0D+00*XBAR)
      XBAR=XBAR/10000
      B2=0.0D+00
      T10=Y(2)*(-3)+Y(3)*2+Y(4)*12+Y(5)*(-9)+Y(6)*(-1)+Y(7)*(-12)
      T20=-3*Y(2)-37.5*Y(3)-6*Y(4)-26*Y(5)-19*Y(6)-44*Y(7)
C
C     Polynomials representing carbon-carbon interaction energy (J/mol)
C     in austenite as a function of the molecular fraction of individual solutes.
C
      P(2)=-2.4233D+07+6.9547D+07*C(2)
      P(2)=+3.864D+06+P(2)*C(2)
      P(2)=+45802.87+(-280061.63+P(2)*C(2))*C(2) 
      P(2)=2013.0341+(763.8167+P(2)*C(2))*C(2)
      P(3)=2.0119D+06+(3.1716D+07-1.3885D+08*C(3))*C(3)
      P(3)=+6287.52+(-21647.96+P(3)*C(3))*C(3)
      P(3)=2012.067+(-1764.095+P(3)*C(3))*C(3)
      P(4)=-2.4968D+07+(1.8838D+08-5.5531D+08*C(4))*C(4)
      P(4)=-54915.32+(1.6216D+06+P(4)*C(4))*C(4)
      P(4)=2006.8017+(2330.2424+P(4)*C(4))*C(4)
      P(5)=-1.3306D+07+(8.411D+07-2.0826D+08*C(5))*C(5)
      P(5)=-37906.61+(1.0328D+06+P(5)*C(5))*C(5)
      P(5)=2006.834+(-2997.314+P(5)*C(5))*C(5)
      P(6)=+8.5676D+06+(-6.7482D+07+2.0837D+08*C(6))*C(6)
      P(6)=+33657.8+(-566827.83+P(6)*C(6))*C(6)
      P(6)=2012.367+(-9224.2655+P(6)*C(6))*C(6)
      P(7)=+5411.7566
     &+(250118.1085-4.1676D+06*C(7))*C(7)
      P(7)=2011.9996+(-6247.9118+P(7)*C(7))*C(7)
      DO 108 IU=2,7
      B3=B3+P(IU)*Y(IU)
      B2=B2+Y(IU)
108   CONTINUE
      IF (B2 .EQ. 0.0D+00) GOTO 455
      W=(B3/B2)*4.187
      GOTO 456
455   W=8054.0
456   CONTINUE
      RETURN
      END
C ******************************************************************************
C Function giving the equilibrium mole fraction of carbon in ferrite
C based on my paper on first order quasichemical theory, Metal Science
C
      DOUBLE PRECISION FUNCTION MAP_STEEL_XALPH(T)
C
      IMPLICIT NONE
      DOUBLE PRECISION T,CTEMP,T0
      PARAMETER(T0=273.0D0)
C
      CTEMP = (T-T0)/900.0D+00
      MAP_STEEL_XALPH=0.1528D-02-0.8816D-02*CTEMP+0.2450D-01*CTEMP**2
     &-0.2417D-01*CTEMP**3+
     &0.6966D-02*CTEMP**4
C
      RETURN
      END
C***************************************************************************
C        SUBROUTINE TRAPE
C
C        PURPOSE
C           TO COMPUTE THE VECTOR OF INTEGRAL VALUES FOR A GIVEN
C           GENERAL TABLE OF ARGUMENT AND FUNCTION VALUES.
C
C        USAGE
C             CALL TRAPE (X,Y,Z,NDIM)
C
C        DESCRIPTION OF PARAMETERS
C           X      - DOUBLE PRECISION INPUT VECTOR OF ARGUMENT VALUES.
C           Y      - DOUBLE PRECISION INPUT VECTOR OF FUNCTION VALUES.
C           Z      - THE RESULTING DP. VECTOR OF INTEGRAL VALUES. Z MAY BE
C                    IDENTICAL WITH X OR Y.
C           NDIM   - THE DIMENSION OF VECTORS X,Y,Z. NDIM MAX. 1000
C
C        REMARKS
C           NO ACTION IN CASE NDIM LESS THAN 1.
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           BEGINNING WITH Z(1)=0, EVALUATION OF VECTOR Z IS DONE BY
C           MEANS OF TRAPEZOIDAL RULE (SECOND ORDER FORMULA).
C           FOR REFERENCE, SEE
C           F.B.HILDEBRAND, INTRODUCTION TO NUMERICAL ANALYSIS,
C           MCGRAW-HILL, NEW YORK/TORONTO/LONDON, 1956, PP.75.
C
C       Subroutine stolen from SSP (IBM), cf. PLUS/1000 X019
C           HO    <881109.1345>
C     ..................................................................
C
      SUBROUTINE MAP_UTIL_TRAPE(X,Y,ANS,NDIM)
C
C
      IMPLICIT NONE
      DOUBLE PRECISION X(1000),Y(1000),AZ(1000)
      DOUBLE PRECISION SUM1,SUM2,ANS
      INTEGER NDIM,I
C
      SUM2=0.D+00
      IF(NDIM-1)4,3,1
C
C     INTEGRATION LOOP
    1 DO 2 I=2,NDIM
      SUM1=SUM2
      SUM2=SUM2+.5D+00*(X(I)-X(I-1))*(Y(I)+Y(I-1))
    2 AZ(I-1)=SUM1
    3 AZ(NDIM)=SUM2
      ANS=SUM2
    4 RETURN
      END
