C H. K. D. H. Bhadeshia, Diffusivity of carbon in austenite
C Department of Materials Science and Metallurgy
C Pembroke Street, Cambridge CB2 3QZ, U. K.
C 31 March 1987
C
C Program for the calculation of the diffusivity of carbon in austenite
C as a function of carbon concentration and temperature. Also accounts for
C the infulence of C, Mn, Si, Ni, Mo, Cr and V on the activity of carbon
C in austenite, and therefore on the diffusivity of carbon.
C
C WDIFF is the carbon--carbon interaction energy in austenite, not
C allowing for the presence of Mo, Cr or V
C
C diffusion coefficient in cm**/s
C
      SUBROUTINE MAP_STEEL_DIFFUS(DIF,X,T,W,R,BOLTZ,HH)
      IMPLICIT NONE
      DOUBLE PRECISION DIF,X,T,W,PSI,THETA,ACTIV,DACTIV,DASH,SIGMA,A5
      DOUBLE PRECISION BOLTZ,HH,R,MAP_STEEL_DCG,MAP_STEEL_CG
      INTEGER IZ
         IZ=12
         A5=1.0D+00
C     DIF=DIFFUSIVITY OF CARBON IN AUSTENITE
C     IZ=COORDINATION OF INTERSTIAL SITE
C     PSI=COMPOSITION DEPENDENCE OF DIFFUSION COEFFICIENT
C     THETA=NO. C ATOMS/ NO. FE ATOMS
C     ACTIV=ACTIVITY OF CARBON IN AUSTENITE
C     R=GAS CONSTANT
C     X=MOLE FRACTION OF CARBON
C     T=ABSOLUTE TEMPERATURE
C     SIGMA=SITE EXCLUSION PROBABLITY
C     W=CARBON CARBON INTERACTION ENERGY IN AUSTENITE
C
      DASH=(BOLTZ*T/HH)*DEXP(-(21230.0D+00/T))*DEXP(-31.84D+00)
      THETA=X/(A5-X)
      ACTIV=MAP_STEEL_CG(X,T,W,R)
      ACTIV=DEXP(ACTIV)
      DACTIV=MAP_STEEL_DCG(X,T,W,R)
      DACTIV=DACTIV*ACTIV
      DACTIV=DACTIV*A5/((A5+THETA)**2)
      SIGMA=A5-DEXP((-(W))/(R*T))
      PSI=ACTIV*(A5+IZ*((A5+THETA)/(A5-(A5+IZ/2)*THETA+(IZ/2)*(A5+IZ/2)*
     &(A5-SIGMA)*THETA*THETA)))+(A5+THETA)*DACTIV
      DIF=DASH*PSI
      RETURN
      END
