C Function MAP_STEEL_G91
C
C Produced by :-
C
C H.K.D.Bhadeshia,
C Phase Transformations Group,
C Department of Materials Science and Metallurgy,
C University of Cambridge,
C Cambridge, UK.
C
C Purpose :-
C
C To calculate the differential of MAP_STEEL_FTO1 with respect to XTO
C  (see subroutine MAP_STEEL_FTO1 for description of parameters).  The 
C  differentiation is used in order to apply the Newton Iteration.
C
C Unpublished work, H. K. D. H. Bhadeshia, University of Cambridge
C  See laboratory book 5B
C
C Input parameters :-
C
C XTO is the carbon concentration at the T0 boundary.
C T is the temperature (in kelvin).
C W is the carbon-carbon interaction energy in austenite 
C  (in joules per mole).
C W1 is the carbon-carbon interaction energy in ferrite 
C  (in joules per mole).
C H1 is the excess partial molar enthalpy of solution of carbon
C  in ferrite (in joules per mole).
C S1 is the excess partial molar entropy of solution of carbon
C  in ferrite (in joules per mole per kelvin).
C F is the energy.
C H is the excess partial molar enthalpy of solution of carbon
C  in austenite (in joules per mole).
C S is the excess partial molar entropy of solution of carbon
C  in austenite (in joules per mole).
C AJ  = 1 - e(W/RT), where R is the universal gas constant.
C AJ1 = 1 - e(W1/RT), where R is the universal gas constant.
C R is the universal gas constant (in joules per mole per kelvin)
C
C----------------------------------------------------------------------
C
       DOUBLE PRECISION FUNCTION MAP_STEEL_G91(XTO,T,W,W1,H1,S1,F,
     &                               H,S,AJ,AJ1,R)
C
C Input arguments.
C
       DOUBLE PRECISION AJ, AJ1, F, H, H1, R, S, S1, T, W, W1, XTO
C
C Local variables.
C
       DOUBLE PRECISION DT5, DT6, FD, FD1, G1
       DOUBLE PRECISION DZEN1 ,DZEN2, DZEN3, DZEN6, DZEN7, DZEN8
       DOUBLE PRECISION V1, V2, V3, V4, V5, V6, V7, V8, V9
C
C Body of function :-
C
       FD = SQRT(1-2*(1+2*AJ)*XTO+(1+8*AJ)*XTO*XTO)
       FD1= SQRT(9-6*XTO*(2*AJ1+3)+(9+16*AJ1)*XTO*XTO)
C
       DT5 = 28080*XTO/(1-XTO)
       DT6 = T/DT5
C
       IF (DT6 .GT. 1.0) THEN
          GOTO 30
       END  IF
C
       IF (DT6 .LT. 0.25) THEN
          GOTO 10
       END  IF
C
       DZEN1 = 0.2307 +42.7974 *DT6-233.8631 *(DT6**2) +645.4485
     &  *(DT6**3) -954.3995 *(DT6**4) +711.8095 *(DT6**5)
     &  -211.5136 *(DT6**6)
       DZEN2 = -2.6702 +45.6337 *DT6 -225.3965 *(DT6**2) +567.7112
     &  *(DT6**3) -771.6466 *(DT6**4) +538.1778 *(DT6**5)
     &  -151.3818 *(DT6**6)
C
       GOTO 20
C
10     DZEN2 = 1
       DZEN1 = 3.295
20     DZEN3 = (((DZEN2*XTO)**2)*(-50898.56)/(1-XTO))+DZEN1*T*XTO*
     &         (0.6623741)
C
       DZEN3 = DZEN3*4.187
       GOTO 40
30     DZEN3 = 0.0
C
40     V1 = FD-1+3*XTO
       V2 = FD+1-3*XTO
       V3 = 1-2*AJ+(4*AJ-1)*XTO-FD
       V4 = 2*AJ*(2*XTO-1)
       V5 = FD1-3+5*XTO
       V6 = FD1+3-5*XTO
       V7 = (XTO-1-2*AJ+8*XTO*AJ)/FD
       V8 = (9*XTO-9-6*AJ1+16*AJ1*XTO)/FD1
       V9 = H1-(H)-(S1-(S))*T-6*W+4*W1
C
       G1 = 2 +DLOG(XTO**2) +4 +DLOG((1-XTO)**4) -10-DLOG((1-2*XTO)**10)
     &  -LOG((V1/V2)**6) -6 *((XTO/V1)*(V7+3+V1*(3-V7)/V2))
     &  +LOG((V3/V4)**6) -6 *((1-XTO)/V3)*(4*AJ*(1-(V3/V4))-V7)
     &  +3 *(LOG(3-4*XTO) -4*XTO/(3-4*XTO)) +DLOG((V5/V6)**4)
     &  +4*(XTO/V5) *(V8+5+(V5/V6)*(5-V8))
C
       IF (DT6 .GT. 1.0) THEN
          GOTO 50
       END  IF
C
       DZEN6 = (-3.3948 +13.6112 *DT6 -13.4376 *(DT6**2))
     &         *T/(28080*((1-XTO)**2))
       DZEN7 = (-3.3118 +15.7462 *DT6 -23.2449 *(DT6**2))
     &         *T/(28080*((1-XTO)**2))
       DZEN8 = 50898 *((DZEN2*XTO)**2)/((1-XTO)**2)
     &         +(-50898* (2* DZEN2 *DZEN6 *(XTO**2) +2 *XTO
     &         *(DZEN2**2))/(1-XTO)) +DZEN1 *T *0.6623741 +DZEN7
     &         *T *XTO *0.6623741
C
       GOTO 60
C
50     DZEN8 = 0.0
C
60     MAP_STEEL_G91 = V9 +R *T *G1 +DZEN8 -F
C
       RETURN
       END
