C H K D H Bhadeshia, 1993
Calculation of hardness of martensite, bainite or ferrite/pearlite mixtures
C
C Based on the work of Ph. Maynier, B. Jungmann and J. Dollet
C Hardenability Concepts with Applications to Steel
C edited by D V Doane and J S Kirkaldy
C The Metallurgical Society of AIME, Warrendale, Pennsylvania
C, publihsed in 1978, pp. 518-545
C
C Molybdenum for martensite assumed same as chromium
C
C C  - carbon concentration in wt. percent
C COOL - cooling rate in K/s
C CR - chromium concentration in wt. percent
C HV - Vicker's pyramidal diamond hardness
C J  - Integer allowing the choice of microstructure
C MN - manganese concentration in wt. percent
C MO - molybdenum concentration in wt. percent
C NI - nickel concentration in wt. percent
C SI - silicon concentration in wt. percent
C V  - vanadium concentration in wt. percent
C
      IMPLICIT NONE                           
      DOUBLE PRECISION C,SI,MN,NI,MO,CR,V,COOL,HV
      INTEGER J
C
C Input concentrations in wt.\%
C
1     WRITE(*,707)
707   FORMAT(19X,' Carbon wt.% ?')
      CALL REED(C)
      IF(C .LT. 0.1D+00 .OR. C .GT. 0.5D+00)
     &CALL BOUND(C,0.1D+00,0.5D+00)

2     WRITE(*,708)
      CALL REED(SI)
      IF(SI .LT. 0.0D+00 .OR. SI .GT. 1.0D+00)
     &CALL BOUND(SI,0.0D+00,1.0D+00)
708   FORMAT(19X,' Silicon wt.% ?')

3     WRITE(*,709)
      CALL REED(MN)
      IF(MN .LT. 0.0D+00 .OR. MN .GT. 2.0D+00)
     &CALL BOUND(MN,0.0D+00,2.0D+00)
709   FORMAT(19X,' Manganese wt.% ?')

4     WRITE(*,710)
      CALL REED(NI)
      IF(NI .LT. 0.0D+00 .OR. NI .GT. 4.0D+00)
     &CALL BOUND(NI,0.0D+00,4.0D+00)
710   FORMAT(19X,' Nickel wt.% ?')

5     WRITE(*,711)
711   FORMAT(19X,' Molybdenum wt.% ?')
      CALL REED(MO)
      IF(MO .LT. 0.0D+00 .OR. MO .GT. 1.0D+00)
     &CALL BOUND(MO,0.0D+00,1.0D+00)

6     WRITE(*,712)
      CALL REED(CR)
712   FORMAT(19X,' Chromium wt.% ?')
      IF(CR .LT. 0.0D+00 .OR. CR .GT. 3.0D+00)
     &CALL BOUND(CR,0.0D+00,3.0D+00)

7     WRITE(*,713)
      CALL REED(V)
713   FORMAT(19X,' Vanadium wt.% ?')
      IF(V .LT. 0.0D+00 .OR. V .GT. 0.2D+00)
     &CALL BOUND(V,0.0D+00,0.2D+00)

C
      IF((MN + Ni + CR + MO) .GT. 5.0) THEN
      WRITE(*,*) ' (Mn + Ni + Cr + Mo) > 5  out of bounds'
      ENDIF
C

8     WRITE(*,714)
C Input cooling rate in K/s -- typically at 700 degrees centigrade
      CALL REED(COOL)
714   FORMAT(19X,' Cooling rate, K/s ?')
      IF(COOL .LT. 0.0D+00 .OR. COOL .GT. 9D+2)
     &CALL BOUND(COOL,0.0D+00,9D+02)
C
C Convert to cooling rate in K/h
      COOL = COOL * 3600.0
C

C
      WRITE(*,100)
100     FORMAT(10X,' What microstructure ?'/
     & 12X, 'Martensite (1), Bainite (2), Ferrite/Pearlite (3)'//)
      READ(*,*)J
      IF(J .EQ. 1) GOTO 10
      IF(J .EQ. 2) GOTO 20
C 
C Ferrite pearlite
C
      HV=42 + 223*C + 30*MN + 12.6*NI + 7*CR + 19*MO
     & + (10 - 19*SI + 4*NI + 8*CR + 130*V)*DLOG10(COOL)
      GOTO 30
C
C Martensite
C
10    HV = 127 + 949*C + 27*SI + 11*MN + 8*NI + 16*CR + 16*MO
     & + 21*DLOG10(COOL)
      GOTO 30
C
C Bainite
C
C The negative sign in front of "323" is a correction from the positive
C  stated in the paper
C
20    HV = 185*C - 323 + 330*SI + 153*MN + 65*NI +144* CR
     & +191*MO + (89 + 53*C -55*SI -22*MN -10*NI 
     & - 20*CR -33*MO)*DLOG10(COOL)
      GOTO 30
C
30    WRITE(*,200) HV
200   FORMAT(10X, 'VICKERS HARDNESS = ', F10.0)
        STOP 
        END
C**************************************************************
C
C H K D H Bhadeshia, 1986
C Tests whether input data are within specified range
C
      SUBROUTINE BOUND(A,B,C)
      IMPLICIT NONE                
      DOUBLE PRECISION A,B,C,D
2      WRITE(*,1)B,C
1     FORMAT(12X,' Input value out of bounds'/
     &14X,' The limits are ',D12.4,' to ', D12.4///
     &14X,' Input new value, or 999 to continue with'/
     &14X,' original risky input                     ')
      CALL REED(D)
      IF(D .EQ. 999.0)GOTO 3
      A=D
      IF(A .LT. B .OR. A .GT. C)GOTO 2
3     RETURN
      END
C****************************************************************
C H K D H Bhadeshia, 1985
C To trap errors during input of data
C
      SUBROUTINE REED(A)
      DOUBLE PRECISION A
996   READ(*,*,ERR=999)A
          GOTO 998
999       WRITE(*,997)
997       FORMAT(19X,' Incorrect Input. Try again'/)
          GOTO 996
998   RETURN
      END

