C**********************************************************************
C
C SUBROUTINE FOR MAP_STEEL_INC_POTENCY
C
C CALCULATES THE CLASSICAL ACTIVATION ENERGY BARRIER TO NUCLEATION AT
C A SPERICAL SUBSTRATE (IE. AN INCLUSION)
C
C ALLOWS FOR:-
C
C (1) INTRUSION BY INCLUSION IN TOP OF NUCLEUS
C (2) VARIABLE INTERFACIAL ENERGIES FOR VARIOUS SYSTEMS
C (3) FACETTED NUCLEUS
C (4) CHEMICAL DEPLETION LOCAL TO THE INCLUSION
C
C COPYRIGHT - SJ JONES & HKDH BHADESHIA, UNIVERSITY OF CAMBRIDGE, UK
C JANUARY 1996
C
C BASED ON A SIMPLER MODEL BY G BARRITTE - PHD THESIS - CAMBRIDGE UNIVERSITY
C
C**********************************************************************
        SUBROUTINE MAP_STEEL_INC_POTENCY(INCGMAX1VOL,GMAX1VOL,RI,
     &UFAFENERGY,FAFENERGY,FIENERGY,AIENERGY,AEB,AEBHOMOG,FRACHOMAEB)

       IMPLICIT NONE
       DOUBLE PRECISION INCGMAX1VOL,GMAX1VOL,RI,UFAFENERGY,
     &FAFENERGY,FIENERGY,AIENERGY,AEB,AEBHOMOG,FRACHOMAEB
       DOUBLE PRECISION PI,RC,TESTIT,PHI,SEPN,PSI,THETA,BETA,
     &FUNCTHETA,FUNCPSI,FUNCBETA,VS,VC1,VC2,VC3,XHGT,YHGT,AS,
     &AC1,AC2,AC4,AF
C
        PARAMETER (PI=3.141592654)
C
C MODELLING THE NUCLEUS GEOMETRY:
C
C PHI=WETTING ANGLE (RAD - ASSUME REACTION AT INCLUSION IS PERPENDICULAR TO
C INCLUSION SURFACE).
C PSI=ANGLE BETWEEN (RAD) CHORD WHICH 'SEPARATES' INCLUSION AND
C FERRITE AND THE TANGENT TO THE INCLUSION AT THE TRIPLE POINT.
C THETA=ANGLE BETWEEN (RAD) CHORD WHICH 'SEPARATES' INCLUSION AND
C FERRITE AND THE TANGENT TO THE FERRITE NUCLEUS AT THE TRIPLE POINT.
C BETA=ANGLE BETWEEN (RAD) CHORD WHICH 'SEPARATES' AUSTENITE AND THE FACETED
C FERRITE AND THE TANGENT TO THE UNFACETED FERRITE AT THE DOUBLE POINT.
C
C CALCULATES ACTIVATION ENERGY BARRIER TO HOMOGENEOUS NUCLEUS:
  
	AEBHOMOG=(16.0*PI/3.0)*(UFAFENERGY**3)/(GMAX1VOL**2.0)

C CALCULATES THE RADIUS OF CURVATURE OF A 'HOMOGENEOUS' NUCLEI IN
C THE POSSIBLY DEPLETED VICINITY OF AN INCLUSION

        RC=(-2.0*UFAFENERGY)/INCGMAX1VOL

C CHECKS IF INTERFACIAL ENERGY TERMS ARE COMPATABLE:

        IF (FAFENERGY.GT.UFAFENERGY) THEN
          WRITE(*,*) "ERROR - INTERFACIAL ENERGY (1) !"
          PAUSE
        ENDIF

        TESTIT=(-1.0*(FIENERGY-AIENERGY)/UFAFENERGY)

        IF ( (TESTIT.GT.1.0).OR.(TESTIT.LT.-1.0) ) THEN
          WRITE(*,*) "ERROR - INTERFACIAL ENERGY (2) !"
          PAUSE
        ENDIF

        PHI=ACOS(-1.0*(FIENERGY-AIENERGY)/UFAFENERGY)

C SEPN=DISTANCE BETWEEN THE CENTRE OF THE INCLUSION AND THE REAL OR NOTIONAL 
C FERRITE NUCLEUS CENTRE.

        SEPN=((RC**2.0)+(RI**2.0)-(2.0*RC*RI*COS(PHI)))**0.5 

C NB - IF RC <= RI THEN THETA IS THE LARGER OF THE NON-INCLUDED ANGLES -
C      THEREFORE FIND PSI FIRST USING THE SINE RULE AND THEN CALCULATE
C      THETA USING SUM OF ANGLES IN A TRIANGLE:

       IF (RC.LE.RI) THEN
        PSI=ASIN(RC*SIN(PHI)/SEPN)
        THETA=(PI-PHI)-PSI
        THETA=THETA
        PSI=PSI
       ENDIF

C NB - IF RC > RI THEN USE REVERSE PROCEDURE:

       IF (RI.LT.RC) THEN
        THETA=ASIN(RI*SIN(PHI)/SEPN)
        PSI=(PI-PHI)-THETA       
        THETA=THETA
        PSI=PSI
       ENDIF

        BETA=ACOS(FAFENERGY/UFAFENERGY)
         
        FUNCTHETA=2.0-(3.0*COS(THETA))+((COS(THETA))**3.0)
        FUNCPSI=2.0-(3.0*COS(PSI))+((COS(PSI))**3.0)
C NB STEVE JONES CORRECTED VERSION (BARRITTE WRONG ? - CHECKED BY HB):
        FUNCBETA=2.0-(3.0*COS(BETA))+((COS(BETA))**3.0)
    
C VOLUME TERMS:

C VS=SPHERE.
C VC1=SPHERICAL SEGMENT LOST DUE SECTIONING OF NUCLEUS.
C VC2=SPHERICAL SEGMENT LOST DUE INTRUSION INTO NUCLEUS.
C VC3=SPHERICAL SEGMENT LOST DUE FORMATION OF FACET.

        VS=(4.0*PI/3.0)*(RC**3.0)
        VC1=(1.0*PI/3.0)*(RC**3.0)*FUNCTHETA
        VC2=(1.0*PI/3.0)*(RI**3.0)*FUNCPSI
C NB STEVE JONES CORRECTED VERSION (BARRITTE WRONG ? - CHECKED BY HB):
        VC3=(1.0*PI/3.0)*(RC**3.0)*FUNCBETA

C NB - MODIFICATION TO CHECK FOR THE POSSIBILTY THAT THE LOW-ENERGY AUSTENITE-
C FERRITE FACET 'INTERSECTS' OR MEETS THE INCLUSION SURFACE:

C TESTS POSITION OF THE LOW-ENERGY A-F FACET IN RELATION TO THE INCLUSION 
C SURFACE (NOTE - TESTED OK FOR ALL POSSIBLE NUCLEUS / INCLUSION GEOMETRIES):

C XHGT=DISTANCE FROM 'TOP' OF INCLUSION TO 'TOP' OF 'UNFACETTED NUCLEUS'.
C YHGT=DISTANCE FROM 'TOP' OF UNFACETTED NUCLEUS TO FACET.

        XHGT=(RC*(1.0+COS(THETA)))-(RI*(1.0-COS(PSI)))
        YHGT=RC*(1.0-COS(BETA))

C IF YHGT > XHGT - THEN THIS MODEL UNSUITABLE - A MODIFIED MODEL CAN BE PRODUCED
C BUT THIS ONLY EXTENDS THE APPLICABILTY BY A V. SMALL MARGIN BECAUSE IF YHGT >> 
C XHGT THEN THE NUCLEUS HAS NO VOLUME! 

        IF (YHGT.GT.XHGT) THEN
         WRITE(*,*) 'ERROR  - FACET INTERSECTS INCLUSION !'
         PAUSE
        ENDIF 
     
C AREA TERMS:

C AS=SPHERE.
C AC1=AREA OF NUCLEUS LOST DUE TO SECTIONING.
C AC2=AREA OF FERRITTE/INCLUSION INTERFACE CREATED (NB
C - SAME AS THE AUSTENITE/INCLUSION INTERFACE DESTROYED).
C AC4=AREA OF NUCLEUS LOST DUE TO FACET FORMATION.
C AF=AREA OF NUCLEUS CREATED DUE TO FACET FORMATION.

        AS=4.0*PI*(RC**2.0)
        AC1=2.0*PI*(RC**2.0)*(1.0-COS(THETA))
        AC2=2.0*PI*(RI**2.0)*(1.0-COS(PSI))
        AC4=2.0*PI*(RC**2.0)*(1.0-COS(BETA))
C NB STEVE JONES CORRECTED VERSION (BARRITTE WRONG ? - CHECKED BY HB):
        AF=1.0*PI*(RC**2.0)*(1.0-((COS(BETA))**2.0))

C CALCULATE ACTIVATION ENERGY BARRIER AT INCLUSION
C IGNORES STRAIN ENERGY TERM THAT OPPOSES NUCLEATION

         AEB=
     &   (INCGMAX1VOL*(VS-(VC1+VC2+VC3)) )
     &  +((AS-AC1-AC4)*UFAFENERGY)
     &  +((AF)*FAFENERGY)
     &  -((AC2)*AIENERGY)
     &  +((AC2)*FIENERGY)

C COMPARE WITH HOMOGENEOUS ACTIVATION ENERGY BARRIER (IE CALC. SHAPE FACTOR)

         FRACHOMAEB=AEB/AEBHOMOG

         RETURN

         END

C XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
