      SUBROUTINE MAP_STEEL_SCHEIL(CC,CSI,CMN,CNI,CMO,CCR,CV
     &,R,C,I,N) 
C 
C Sheil equation is applied in this subroutine by K.Ichikawa.  
C on 12 Jan. 1995.  C However, g in original Sheil equation is substituted 
C to i/n-1/(2*n).  
C n is a number of division.  
C i means 'i'th from the g=0.  
C 
C
      IMPLICIT NONE
      DOUBLE PRECISION C(7),CC,CSI,CMN,CNI,CMO,CCR,CV,R,M
      DOUBLE PRECISION KC,KSI,KMN,KNI,KMO,KCR,KV,RN,RI
      INTEGER I,N
      CALL MAP_STEEL_EDC(CC,CSI,CMN,CNI,CMO,CCR,CV,KC,
     &KSI,KMN,KNI,KMO,KCR,KV,R,M)
      RN=FLOAT(N)
      RI=FLOAT(I)
      C(1)=KC*CC*((1.00-((RI/RN)-(1.00/(2.00*RN))))**(KC -1.00))
      C(2)=KSI*CSI*((1.00-((RI/RN)-(1.00/(2.00*RN))))**(KSI-1.00))
      C(3)=KMN*CMN*((1.00-((RI/RN)-(1.00/(2.00*RN))))**(KMN-1.00))
      C(4)=KNI*CNI*((1.00-((RI/RN)-(1.00/(2.00*RN))))**(KNI-1.00))
      C(5)=KMO*CMO*((1.00-((RI/RN)-(1.00/(2.00*RN))))**(KMO-1.00))
      C(6)=KCR*CCR*((1.00-((RI/RN)-(1.00/(2.00*RN))))**(KCR-1.00))
      C(7)=KV *CV*((1.00-((RI/RN)-(1.00/(2.00*RN))))**(KV -1.00))
      RETURN
      END 

